/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.api.manager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.baidu.idl.face.api.CollectVerifyActivity;
import com.baidu.idl.face.api.manager.FaceInitCallback;
import com.baidu.idl.face.api.manager.FaceServiceCallbck;
import com.baidu.idl.face.api.manager.HttpService;
import com.baidu.idl.face.api.utils.IntentUtil;
import com.baidu.idl.face.api.utils.VerifyErrorCodeUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.callback.InitCallback;
import com.baidu.idl.facelive.api.callback.LivenessCallback;
import com.baidu.idl.facelive.api.entity.InitOption;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.liantian.ac.LH;
import java.util.HashMap;
import java.util.Map;

public class FaceServiceManager {
    private static final String TAG = "FaceServiceManager";
    public Map paramsMap;
    public FaceServiceCallbck faceServiceCallbck;

    private FaceServiceManager() {
    }

    public static FaceServiceManager getInstance() {
        return Holder.INSTANSE;
    }

    public void init(Context context, String licenseKey, String licenseName, String keyName, final FaceInitCallback faceInitCallback) {
        LH.setAgreePolicy((Context)context.getApplicationContext(), (boolean)true);
        LH.init((Context)context.getApplicationContext(), (String)licenseKey, null, (String)keyName);
        InitOption initOption = new InitOption();
        initOption.licenseKey = licenseKey;
        initOption.licenseFileName = licenseName;
        FaceLiveManager.getInstance().init(context, initOption, new InitCallback(){

            public void onSuccess(int code, String desc) {
                if (faceInitCallback != null) {
                    faceInitCallback.onCallback(code, "face init success!");
                }
            }

            public void onError(int code, String desc) {
                if (faceInitCallback != null) {
                    faceInitCallback.onCallback(code, "face init failed:" + desc);
                }
            }
        });
    }

    public void startFaceCollect(final Context context, final FaceServiceCallbck faceServiceCallbck) {
        if (faceServiceCallbck != null) {
            this.faceServiceCallbck = faceServiceCallbck;
            if (!LH.isInitSuc((int)1) && HttpService.getInstance().isSafe()) {
                HashMap<String, Object> resultParams = new HashMap<String, Object>();
                resultParams.put("resultMsg", "\u5b89\u5168\u6a21\u5757\u672a\u4e0b\u8f7d\u6210\u529f");
                faceServiceCallbck.onCallback(-1005, resultParams);
                FaceServiceManager.getInstance().faceServiceCallbck = null;
                return;
            }
            FaceLiveManager.getInstance().startFaceLiveness((Activity)context, null, new LivenessCallback(){

                public void onLivenessResult(LivenessResult livenessResult) {
                    if (livenessResult == null) {
                        return;
                    }
                    if (!FaceLiveManager.getInstance().getFaceConfig().isShowResultView() && faceServiceCallbck != null) {
                        int code = livenessResult.getSafetyCode();
                        HashMap<String, Object> resultParams = new HashMap<String, Object>();
                        if (code == 1) {
                            resultParams.put("resultMsg", "FaceCollect Success!");
                            if (HttpService.getInstance().isSafe()) {
                                resultParams.put("sKey", livenessResult.getRequestInfo().sKey);
                                resultParams.put("xDeviceId", livenessResult.getRequestInfo().xDeviceId);
                            }
                            resultParams.put("data", livenessResult.getRequestInfo().data);
                            if (!TextUtils.isEmpty((CharSequence)livenessResult.getRequestInfo().path)) {
                                resultParams.put("path", livenessResult.getRequestInfo().path);
                            }
                            faceServiceCallbck.onCallback(0, resultParams);
                            FaceServiceManager.getInstance().faceServiceCallbck = null;
                        } else {
                            resultParams.put("resultMsg", context.getResources().getString(VerifyErrorCodeUtils.getCodeMessage(code)));
                            faceServiceCallbck.onCallback(code, resultParams);
                            FaceServiceManager.getInstance().faceServiceCallbck = null;
                        }
                    }
                }
            });
        }
    }

    public void startFaceRecognize(Context context, Map<String, Object> params, FaceServiceCallbck faceServiceCallbck) {
        if (params == null) {
            return;
        }
        this.paramsMap = params;
        if (params != null) {
            params.put("recogType", "FaceRecognize");
        }
        this.accessFaceService(context, params, faceServiceCallbck);
    }

    public void startFaceLiveness(Context context, Map<String, Object> params, FaceServiceCallbck faceServiceCallbck) {
        if (params == null) {
            return;
        }
        this.paramsMap = params;
        if (params != null) {
            params.put("recogType", "FaceLiveness");
        }
        this.accessFaceService(context, params, faceServiceCallbck);
    }

    private void accessFaceService(Context context, Map<String, Object> params, FaceServiceCallbck faceServiceCallbck) {
        if (faceServiceCallbck != null && params != null) {
            this.faceServiceCallbck = faceServiceCallbck;
            if (!LH.isInitSuc((int)1) && HttpService.getInstance().isSafe()) {
                HashMap<String, Object> resultParams = new HashMap<String, Object>();
                resultParams.put("resultMsg", "\u5b89\u5168\u6a21\u5757\u672a\u4e0b\u8f7d\u6210\u529f");
                faceServiceCallbck.onCallback(-1005, resultParams);
                FaceServiceManager.getInstance().faceServiceCallbck = null;
                return;
            }
            if (!this.checkStringField(params, "access_token", -1002, "accessToken\u53c2\u6570\u4e0d\u5408\u6cd5")) {
                return;
            }
            if ("FaceRecognize".equals((String)params.get("recogType"))) {
                if (!this.checkStringField(params, "name", -1003, "\u59d3\u540d\u53c2\u6570\u4e0d\u5408\u6cd5")) {
                    return;
                }
                if (!this.checkStringField(params, "id_card_number", -1004, "\u8bc1\u4ef6\u53f7\u53c2\u6570\u4e0d\u5408\u6cd5")) {
                    return;
                }
            }
            this.startFaceVerify(context, params);
        }
    }

    private boolean checkStringField(Map<String, Object> params, String field, int resultCode, String resultMsg) {
        if (!params.containsKey(field)) {
            if (this.faceServiceCallbck != null) {
                HashMap<String, Object> resultParams = new HashMap<String, Object>();
                resultParams.put("resultMsg", resultMsg);
                this.faceServiceCallbck.onCallback(resultCode, resultParams);
                this.faceServiceCallbck = null;
            }
            return false;
        }
        Object nameObject = params.get(field);
        if (!(nameObject instanceof String)) {
            if (this.faceServiceCallbck != null) {
                HashMap<String, Object> resultParams = new HashMap<String, Object>();
                resultParams.put("resultMsg", resultMsg);
                this.faceServiceCallbck.onCallback(resultCode, resultParams);
                this.faceServiceCallbck = null;
            }
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)((String)params.get(field)))) {
            if (this.faceServiceCallbck != null) {
                HashMap<String, Object> resultParams = new HashMap<String, Object>();
                resultParams.put("resultMsg", resultMsg);
                this.faceServiceCallbck.onCallback(resultCode, resultParams);
                this.faceServiceCallbck = null;
            }
            return false;
        }
        return true;
    }

    private void startFaceVerify(final Context context, final Map<String, Object> params) {
        FaceLiveManager.getInstance().startFaceLiveness((Activity)context, null, new LivenessCallback(){

            public void onLivenessResult(LivenessResult livenessResult) {
                if (livenessResult == null) {
                    return;
                }
                if (!FaceLiveManager.getInstance().getFaceConfig().isShowResultView()) {
                    int code = livenessResult.getSafetyCode();
                    if (code == 1) {
                        if (livenessResult.getRequestInfo() != null) {
                            FaceServiceManager.this.startVerifyPage(context, params, livenessResult);
                        }
                    } else if (FaceServiceManager.this.faceServiceCallbck != null) {
                        HashMap<String, Object> resultParams = new HashMap<String, Object>();
                        resultParams.put("resultMsg", context.getResources().getString(VerifyErrorCodeUtils.getCodeMessage(code)));
                        FaceServiceManager.this.faceServiceCallbck.onCallback(code, resultParams);
                        FaceServiceManager.getInstance().faceServiceCallbck = null;
                    }
                }
            }
        });
    }

    private void startVerifyPage(Context context, Map<String, Object> params, LivenessResult livenessResult) {
        if (params != null) {
            Intent intent = new Intent(context, CollectVerifyActivity.class);
            if (HttpService.getInstance().isSafe()) {
                IntentUtil.getInstance().setImageData(livenessResult.getRequestInfo().data);
                intent.putExtra("sKey", livenessResult.getRequestInfo().sKey);
                intent.putExtra("xDeviceId", livenessResult.getRequestInfo().xDeviceId);
            }
            intent.putExtra("path", livenessResult.getRequestInfo().path);
            intent.putExtra("accessToken", (String)params.get("access_token"));
            intent.putExtra("recogType", (String)params.get("recogType"));
            context.startActivity(intent);
        }
    }

    public static void release() {
        FaceLiveManager.getInstance().release();
    }

    private static final class Holder {
        private static final FaceServiceManager INSTANSE = new FaceServiceManager();

        private Holder() {
        }
    }
}

