/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.api;

import android.animation.ObjectAnimator;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.ImageView;
import com.baidu.idl.face.api.BaseActivity;
import com.baidu.idl.face.api.OnResultListener;
import com.baidu.idl.face.api.R;
import com.baidu.idl.face.api.exception.FaceException;
import com.baidu.idl.face.api.manager.FaceServiceCallbck;
import com.baidu.idl.face.api.manager.FaceServiceManager;
import com.baidu.idl.face.api.manager.HttpService;
import com.baidu.idl.face.api.model.DynamicParams;
import com.baidu.idl.face.api.utils.IntentUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.json.JSONException;

public class CollectVerifyActivity
extends BaseActivity {
    private ImageView mImageAnim;
    private String recogType;
    private float liveScore;
    private String sKey;
    private String xDeviceId;
    private String data;
    private String path;
    private String accessToken;
    private ObjectAnimator mRotationAnimator;
    private String[] imageArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_collect_verify);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mImageAnim = (ImageView)this.findViewById(R.id.image_anim);
        this.startAnim(this.mImageAnim);
    }

    private void initData() {
        Intent intent = this.getIntent();
        if (intent != null) {
            if (HttpService.getInstance().isSafe()) {
                this.sKey = intent.getStringExtra("sKey");
                this.xDeviceId = intent.getStringExtra("xDeviceId");
            }
            this.path = intent.getStringExtra("path");
            this.recogType = intent.getStringExtra("recogType");
            this.accessToken = intent.getStringExtra("accessToken");
            this.liveScore = intent.getFloatExtra("livenessScore", 0.0f);
            this.policeVerifyFromServer();
        }
    }

    protected void onStop() {
        super.onStop();
        this.cancelAnim();
    }

    private void startAnim(ImageView imageAnim) {
        this.mRotationAnimator = ObjectAnimator.ofFloat((Object)imageAnim, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        this.mRotationAnimator.setDuration(1000L);
        this.mRotationAnimator.setRepeatCount(-1);
        this.mRotationAnimator.setRepeatMode(1);
        this.mRotationAnimator.start();
    }

    private void cancelAnim() {
        if (this.mRotationAnimator != null) {
            this.mRotationAnimator.cancel();
            this.mRotationAnimator.end();
        }
    }

    private void policeVerifyFromServer() {
        DynamicParams params = new DynamicParams();
        if (HttpService.getInstance().isSafe()) {
            params.putBooleanParam("risk_identify", true);
            try {
                this.data = IntentUtil.getInstance().getImageData().getString("data");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            params.setData(this.data);
        } else {
            params.putBooleanParam("risk_identify", false);
            this.imageArray = IntentUtil.getInstance().getImageArray();
            params.putArrayParam("image_list", this.imageArray);
        }
        StringBuilder address = null;
        if ("FaceLiveness".equals(this.recogType)) {
            address = new StringBuilder(HttpService.getInstance().getLivenessUrl());
            address.append("?model=").append("sec");
            address.append("&access_token=").append(this.accessToken);
            params.setScene("financial_level");
            if (HttpService.getInstance().isSafe()) {
                params.setSdkVersion("4");
                params.putParam("s_key", this.sKey);
                params.putParam("device_id", this.xDeviceId);
            } else {
                params.setSdkVersion("1");
            }
            params.putParam("face_field", "age,beauty,expression,face_shape,gender,glasses,landmark,quality,face_type,spoofing");
            params.putParam(FaceServiceManager.getInstance().paramsMap);
        } else {
            address = new StringBuilder(HttpService.getInstance().getRecognizeUrl());
            address.append("?model=").append("sec");
            address.append("&access_token=").append(this.accessToken);
            if (HttpService.getInstance().isSafe()) {
                try {
                    address.append("&skey=").append(URLEncoder.encode(this.sKey, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    address.append("&x_device_id=").append(URLEncoder.encode(this.xDeviceId, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                params.setSecLevel("lite");
            } else {
                params.setSecLevel("common");
                params.putParam("image", this.imageArray[0]);
            }
            params.putParam(FaceServiceManager.getInstance().paramsMap);
        }
        params.setApp("android");
        HttpService.getInstance().policeVerify(address.toString(), params, new OnResultListener<String>(){

            @Override
            public void onResult(String result) {
                if (result == null) {
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("data", CollectVerifyActivity.this.data);
                params.put("resultMsg", CollectVerifyActivity.this.recogType + " Success!");
                params.put("resultScore", Float.valueOf(CollectVerifyActivity.this.liveScore));
                params.put("sKey", CollectVerifyActivity.this.sKey);
                params.put("xDeviceId", CollectVerifyActivity.this.xDeviceId);
                if (!TextUtils.isEmpty((CharSequence)CollectVerifyActivity.this.path)) {
                    params.put("path", CollectVerifyActivity.this.path);
                }
                params.put("resultJson", result);
                FaceServiceCallbck faceServiceCallbck = FaceServiceManager.getInstance().faceServiceCallbck;
                if (faceServiceCallbck != null) {
                    faceServiceCallbck.onCallback(0, params);
                    FaceServiceManager.getInstance().faceServiceCallbck = null;
                }
                CollectVerifyActivity.this.finish();
            }

            @Override
            public void onError(FaceException error) {
                if (error == null) {
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("resultMsg", error.getErrorMessage());
                params.put("resultScore", Float.valueOf(CollectVerifyActivity.this.liveScore));
                FaceServiceCallbck faceServiceCallbck = FaceServiceManager.getInstance().faceServiceCallbck;
                if (faceServiceCallbck != null) {
                    faceServiceCallbck.onCallback(error.getErrorCode(), params);
                    FaceServiceManager.getInstance().faceServiceCallbck = null;
                }
                CollectVerifyActivity.this.finish();
            }
        });
    }

    protected void onDestroy() {
        super.onDestroy();
        IntentUtil.getInstance().setImageData(null);
    }
}

