/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.StringName;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.handler.WeixinPreferences;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.WeiXinShareContent;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import com.umeng.socialize.utils.UrlUtil;
import com.umeng.socialize.weixin.net.WXAuthUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UMWXHandler
extends UMSSOHandler {
    private static final String TAG = "UMWXHandler";
    private static final int REFRESH_TOKEN_EXPIRES = 604800;
    private static final int RESP_TYPE_AUTH = 1;
    private static final int RESP_TYPE_SHARE = 2;
    private String VERSION = "7.3.2";
    private static String sScope = "snsapi_userinfo,snsapi_friend,snsapi_message";
    private PlatformConfig.APPIDPlatform config;
    private WeixinPreferences weixinPreferences;
    private UMAuthListener mAuthListener;
    private UMShareListener umShareListener;
    private SHARE_MEDIA mTarget = SHARE_MEDIA.WEIXIN;
    private IWXAPI mWXApi;
    private Context mAppContext;
    private String mFileProvider;
    private static final String REFRESH_TOKEN_EXPIRES_KEY = "refresh_token_expires";
    private static final String NICKNAME = "nickname";
    private static final String LANGUAGE = "language";
    private static final String HEADIMGURL = "headimgurl";
    private static final String SEX = "sex";
    private static final String PRIVILEGE = "privilege";
    private static final String ERRORCODE = "errcode";
    private static final String ERRMSG = "errmsg";
    private static final String ERROR_CODE_TOKEN_FAIL = "40001";
    private static final String ERROR_CODE_TOKEN_REFESH_FAIL = "40030";
    private static final String ERROR_CODE_TOKEN_ACCESS_FAIL = "42002";
    private IWXAPIEventHandler mEventHandler = new IWXAPIEventHandler(){

        public void onResp(BaseResp resp) {
            int type = resp.getType();
            switch (type) {
                case 1: {
                    UMWXHandler.this.onAuthCallback((SendAuth.Resp)resp);
                    break;
                }
                case 2: {
                    UMWXHandler.this.onShareCallback((SendMessageToWX.Resp)resp);
                    break;
                }
            }
        }

        public void onReq(BaseReq req) {
        }
    };

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mAppContext = context.getApplicationContext();
        this.weixinPreferences = new WeixinPreferences(this.mAppContext, "weixin");
        this.config = (PlatformConfig.APPIDPlatform)p;
        if (TextUtils.isEmpty((CharSequence)this.config.getFileProvider())) {
            SLog.E((String)UmengText.WX.WEIXIN_FILE_PROVIDER_ERROR);
        } else {
            this.mFileProvider = this.config.getFileProvider();
        }
        this.mWXApi = WXAPIFactory.createWXAPI((Context)context.getApplicationContext(), (String)this.config.appId, (boolean)this.getShareConfig().getOpenWXAnalytics());
        this.mWXApi.registerApp(this.config.appId);
    }

    public String getVersion() {
        return this.VERSION;
    }

    public void setAuthListener(UMAuthListener listener) {
        super.setAuthListener(listener);
        this.mAuthListener = listener;
    }

    public boolean isHasAuthListener() {
        return this.mAuthListener != null;
    }

    public void authorize(final UMAuthListener listener) {
        if (this.config != null) {
            this.mTarget = this.config.getName();
        }
        this.mAuthListener = listener;
        if (!this.isInstall()) {
            if (Config.isJumptoAppStore) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"http://log.umsns.com/link/weixin/download/"));
                ((Activity)this.mWeakAct.get()).startActivity(intent);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getAuthListener(listener).onError(UMWXHandler.this.mTarget, 0, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            };
            this.runInMainThread(runnable);
            return;
        }
        if (this.isAuthValid()) {
            String refreshToken = this.getRefreshToken();
            String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + this.config.appId + "&grant_type=refresh_token&refresh_token=" + refreshToken;
            this.loadOauthData(url);
            String refreshToken1 = this.getRefreshToken();
            final Map<String, String> map = this.getAuthWithRefreshToken(refreshToken);
            if (map.containsKey(ERRORCODE) && (map.get(ERRORCODE).equals(ERROR_CODE_TOKEN_ACCESS_FAIL) || map.get(ERRORCODE).equals(ERROR_CODE_TOKEN_REFESH_FAIL))) {
                this.weixinPreferencesDelete();
                this.authorize(listener);
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getAuthListener(UMWXHandler.this.mAuthListener).onComplete(SHARE_MEDIA.WEIXIN, 0, map);
                }
            };
            this.runInMainThread(runnable);
        } else {
            SendAuth.Req req = new SendAuth.Req();
            req.scope = sScope;
            req.state = "none";
            this.mWXApi.sendReq((BaseReq)req);
        }
    }

    private void runInMainThread(Runnable runnable) {
        QueuedWork.runInMain((Runnable)runnable);
    }

    public boolean isAuthorize() {
        return this.weixinPreferences.isAuth();
    }

    private void loadOauthData(String url) {
        String response = WXAuthUtils.request(url);
        Bundle bundle = this.parseAuthData(response);
        this.setBundle(bundle);
    }

    private Bundle parseAuthData(String response) {
        Bundle bundle = new Bundle();
        if (TextUtils.isEmpty((CharSequence)response)) {
            return bundle;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            Iterator iterator = jsonObject.keys();
            String key = "";
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                bundle.putString(key, jsonObject.optString(key));
            }
            bundle.putLong(REFRESH_TOKEN_EXPIRES_KEY, 604800L);
            bundle.putString("accessToken", bundle.getString("access_token"));
            bundle.putString("expiration", bundle.getString("expires_in"));
            bundle.putString("refreshToken", bundle.getString("refresh_token"));
            bundle.putString("uid", bundle.getString("unionid"));
        }
        catch (JSONException e) {
            SLog.error((Throwable)e);
        }
        return bundle;
    }

    private Map<String, String> getAuthWithRefreshToken(String refresh_token) {
        StringBuilder authURL = new StringBuilder();
        authURL.append("https://api.weixin.qq.com/sns/oauth2/refresh_token?");
        authURL.append("appid=").append(this.config.appId);
        authURL.append("&grant_type=refresh_token");
        authURL.append("&refresh_token=").append(refresh_token);
        String response = WXAuthUtils.request(authURL.toString());
        Map map = null;
        try {
            map = SocializeUtils.jsonToMap((String)response);
            map.put("unionid", this.getUid());
        }
        catch (Exception e) {
            SLog.error((Throwable)e);
        }
        return map;
    }

    private void getAuthWithCode(String code, final UMAuthListener listener) {
        final StringBuilder authURL = new StringBuilder();
        if (this.config.appkey != null && !this.config.appkey.isEmpty()) {
            authURL.append("https://api.weixin.qq.com/sns/oauth2/access_token?");
            authURL.append("appid=").append(this.config.appId);
            authURL.append("&secret=").append(this.config.appkey);
            authURL.append("&code=").append(code);
            authURL.append("&grant_type=authorization_code");
            QueuedWork.runInBack((Runnable)new Runnable(){

                @Override
                public void run() {
                    String response = WXAuthUtils.request(authURL.toString());
                    Map map = null;
                    try {
                        map = SocializeUtils.jsonToMap((String)response);
                        if (map == null || map.size() == 0) {
                            UMWXHandler.this.getMap();
                        }
                        Bundle bundle = UMWXHandler.this.parseAuthData(response);
                        UMWXHandler.this.setBundle(bundle);
                        final Map finalMap = map;
                        QueuedWork.runInMain((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (finalMap.get(UMWXHandler.ERRORCODE) != null) {
                                    UMWXHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.WEIXIN, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + (String)finalMap.get(UMWXHandler.ERRMSG)));
                                } else {
                                    UMWXHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.WEIXIN, 0, finalMap);
                                }
                                finalMap.put("aid", ((UMWXHandler)UMWXHandler.this).config.appId);
                                finalMap.put("as", ((UMWXHandler)UMWXHandler.this).config.appkey);
                                finalMap.put("uid", finalMap.get("openid"));
                                finalMap.put("unionid", finalMap.get("unionid"));
                            }
                        });
                    }
                    catch (Exception e) {
                        SLog.error((Throwable)e);
                    }
                }
            }, (boolean)true);
        } else {
            authURL.append("https://oauth2.umeng.com/oauth/token/acquire?");
            String appkey = SocializeUtils.getAppkey((Context)this.getContext());
            authURL.append("appkey=").append(appkey);
            authURL.append("&source=").append("wechat");
            authURL.append("&appId=").append(this.config.appId);
            authURL.append("&code=").append(code);
            QueuedWork.runInBack((Runnable)new Runnable(){

                @Override
                public void run() {
                    String response = WXAuthUtils.request(authURL.toString());
                    HashMap<String, String> map = null;
                    try {
                        map = new HashMap<String, String>();
                        JSONObject jsonObject = SocializeUtils.jsonObjectExt((String)response);
                        if (jsonObject != null) {
                            if (jsonObject.getInt("code") == 200) {
                                jsonObject = jsonObject.getJSONObject("data");
                            }
                            Iterator keys = jsonObject.keys();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                map.put(key, jsonObject.get(key) + "");
                            }
                        }
                        if (map == null || map.size() == 0) {
                            UMWXHandler.this.getMap();
                        }
                        if (jsonObject != null) {
                            Bundle bundle = UMWXHandler.this.parseAuthData(jsonObject.toString());
                            UMWXHandler.this.setBundle(bundle);
                        }
                        final HashMap<String, String> finalMap = map;
                        QueuedWork.runInMain((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (finalMap.get(UMWXHandler.ERRORCODE) != null || finalMap.get("code") != null) {
                                    Throwable throwable = new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + (String)finalMap.get(UMWXHandler.ERRMSG));
                                    UMWXHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.WEIXIN, 0, throwable);
                                } else {
                                    UMWXHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.WEIXIN, 0, finalMap);
                                }
                                finalMap.put("aid", ((UMWXHandler)UMWXHandler.this).config.appId);
                                finalMap.put("as", ((UMWXHandler)UMWXHandler.this).config.appkey);
                                finalMap.put("uid", finalMap.get("openid"));
                                finalMap.put("unionid", finalMap.get("unionid"));
                            }
                        });
                    }
                    catch (Exception e) {
                        SLog.error((Throwable)e);
                    }
                }
            }, (boolean)true);
        }
    }

    public boolean isInstall() {
        return this.mWXApi != null && this.mWXApi.isWXAppInstalled();
    }

    private void onAuthCallback(SendAuth.Resp resp) {
        if (resp.errCode == 0) {
            this.getAuthWithCode(resp.code, this.mAuthListener);
        } else if (resp.errCode == -2) {
            this.getAuthListener(this.mAuthListener).onCancel(SHARE_MEDIA.WEIXIN, 0);
        } else if (resp.errCode == -6) {
            this.getAuthListener(this.mAuthListener).onError(SHARE_MEDIA.WEIXIN, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + UmengText.errorWithUrl((String)UmengText.AUTH.AUTH_DENIED, (String)UrlUtil.WX_ERROR_SIGN)));
        } else if (resp.errCode == -4) {
            this.getAuthListener(this.mAuthListener).onCancel(SHARE_MEDIA.WEIXIN, 0);
        } else {
            CharSequence err = TextUtils.concat((CharSequence[])new CharSequence[]{"weixin auth error (", String.valueOf(resp.errCode), "):", resp.errStr});
            this.getAuthListener(this.mAuthListener).onError(SHARE_MEDIA.WEIXIN, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + err));
        }
    }

    public String getSDKVersion() {
        return "3.1.1";
    }

    public void deleteAuth(final UMAuthListener listener) {
        this.weixinPreferencesDelete();
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UMWXHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.WEIXIN, 1, null);
            }
        });
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        return 10086;
    }

    private void fetchUserInfo(final UMAuthListener listener) {
        String openid = this.getOpenid();
        String accessToken = this.getAccessToken();
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder.append(accessToken).append("&openid=").append(openid);
        builder.append("&lang=zh_CN");
        final String jsonStr = WXAuthUtils.request(builder.toString());
        if (TextUtils.isEmpty((CharSequence)jsonStr) || jsonStr.startsWith("##")) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.WEIXIN, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + jsonStr));
                }
            });
            return;
        }
        final Map<String, String> map = this.parseUserInfo(jsonStr);
        if (map == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.WEIXIN, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + jsonStr));
                }
            });
        } else if (map.containsKey(ERRORCODE)) {
            if (map.get(ERRORCODE).equals(ERROR_CODE_TOKEN_FAIL)) {
                this.weixinPreferencesDelete();
                this.authorize(listener);
            } else {
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UMWXHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.WEIXIN, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + (String)map.get(UMWXHandler.ERRORCODE)));
                    }
                });
            }
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.WEIXIN, 2, map);
                }
            });
        }
    }

    public void getPlatformInfo(final UMAuthListener listener) {
        if (this.getShareConfig().isNeedAuthOnGetUserInfo()) {
            this.weixinPreferencesDelete();
        }
        this.authorize(new UMAuthListener(){

            public void onStart(SHARE_MEDIA platform) {
            }

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                QueuedWork.runInBack((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UMWXHandler.this.fetchUserInfo(listener);
                    }
                }, (boolean)true);
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                UMWXHandler.this.getAuthListener(listener).onError(platform, action, t);
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
                UMWXHandler.this.getAuthListener(listener).onCancel(platform, action);
            }
        });
    }

    private Map<String, String> parseUserInfo(String result) {
        if (TextUtils.isEmpty((CharSequence)result)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            int len;
            JSONObject jsonObject = new JSONObject(result);
            boolean error = jsonObject.has(ERRORCODE);
            if (error) {
                map.put(ERRORCODE, jsonObject.getString(ERRORCODE));
                map.put(ERRMSG, jsonObject.getString(ERRMSG));
                return map;
            }
            map.put("openid", jsonObject.optString("openid"));
            map.put("screen_name", jsonObject.optString(NICKNAME));
            map.put("name", jsonObject.optString(NICKNAME));
            map.put(LANGUAGE, jsonObject.optString(LANGUAGE));
            map.put("city", jsonObject.optString("city"));
            map.put("province", jsonObject.optString("province"));
            map.put("country", jsonObject.optString("country"));
            map.put("profile_image_url", jsonObject.optString(HEADIMGURL));
            map.put("iconurl", jsonObject.optString(HEADIMGURL));
            map.put("unionid", jsonObject.optString("unionid"));
            map.put("uid", jsonObject.optString("unionid"));
            map.put("gender", this.getGender(jsonObject.optString(SEX)));
            JSONArray jsonArray = jsonObject.optJSONArray(PRIVILEGE);
            int n = len = jsonArray == null ? 0 : jsonArray.length();
            if (len > 0) {
                String[] privileges = new String[len];
                for (int i = 0; i < len; ++i) {
                    privileges[i] = jsonArray.get(i).toString();
                }
                map.put(PRIVILEGE, privileges.toString());
            }
            map.put("access_token", this.getAccessToken());
            map.put("refreshToken", this.getRefreshToken());
            map.put("expires_in", String.valueOf(this.getAccessTokenTTL()));
            map.put("accessToken", this.getAccessToken());
            map.put("refreshToken", this.getRefreshToken());
            map.put("expiration", String.valueOf(this.getAccessTokenTTL()));
        }
        catch (JSONException e) {
            SLog.error((Throwable)e);
            return Collections.emptyMap();
        }
        return map;
    }

    public String getGender(Object object) {
        String male = StringName.male;
        String female = StringName.female;
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            if (object.equals("m") || object.equals("1") || object.equals(UmengText.MAN)) {
                return male;
            }
            if (object.equals("f") || object.equals("2") || object.equals(UmengText.WOMAN)) {
                return female;
            }
            return object.toString();
        }
        if (object instanceof Integer) {
            if ((Integer)object == 1) {
                return male;
            }
            if ((Integer)object == 2) {
                return female;
            }
            return object.toString();
        }
        return object.toString();
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        if (this.config != null) {
            this.mTarget = this.config.getName();
        }
        if (!this.isInstall()) {
            if (Config.isJumptoAppStore) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"https://log.umsns.com/link/weixin/download/"));
                ((Activity)this.mWeakAct.get()).startActivity(intent);
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getShareListener(listener).onError(UMWXHandler.this.mTarget, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            });
            return false;
        }
        WeiXinShareContent shareContent = new WeiXinShareContent(content);
        if (this.mShareConfig != null) {
            shareContent.setCompressListener(this.mShareConfig.getCompressListener());
        }
        if (!this.isAbleShareEmoji(this.mTarget, shareContent)) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getShareListener(listener).onError(UMWXHandler.this.mTarget, new Throwable(UmengErrorCode.ShareDataTypeIllegal.getMessage() + UmengText.WX.WX_CIRCLE_NOT_SUPPORT_EMOJ));
                }
            });
            return false;
        }
        if (!this.isAbleShareMin(this.mTarget, shareContent)) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getShareListener(listener).onError(UMWXHandler.this.mTarget, new Throwable(UmengErrorCode.ShareDataTypeIllegal.getMessage() + UmengText.WX.WX_CIRCLE_NOT_SUPPORT_MIN));
                }
            });
            return false;
        }
        this.umShareListener = listener;
        return this.shareTo(shareContent);
    }

    private boolean isAbleShareEmoji(SHARE_MEDIA target, WeiXinShareContent shareContent) {
        return shareContent.getmStyle() != 64 || target != SHARE_MEDIA.WEIXIN_CIRCLE && target != SHARE_MEDIA.WEIXIN_FAVORITE;
    }

    public boolean isAbleShareMin(SHARE_MEDIA target, WeiXinShareContent shareContent) {
        return shareContent.getmStyle() != 128 || target != SHARE_MEDIA.WEIXIN_CIRCLE && target != SHARE_MEDIA.WEIXIN_FAVORITE;
    }

    public boolean isSupport() {
        return this.mWXApi.getWXAppSupportAPI() >= 0x21020001;
    }

    public boolean checkVersionValid() {
        return this.mWXApi.getWXAppSupportAPI() >= 654314752;
    }

    public boolean checkAndroidNotBelowN() {
        return Build.VERSION.SDK_INT >= 24;
    }

    private boolean shareTo(WeiXinShareContent shareContent) {
        if (shareContent.isBySystem()) {
            ComponentName cn;
            String uri;
            File file;
            String text = shareContent.getText();
            UMImage image = shareContent.getImage();
            Intent shareIntent = new Intent();
            shareIntent.setFlags(0x10000000);
            shareIntent.setAction("android.intent.action.SEND");
            if (!TextUtils.isEmpty((CharSequence)text)) {
                shareIntent.putExtra("android.intent.extra.TEXT", text);
                shareIntent.putExtra("Kdescription", text);
            }
            Uri imageUri = null;
            if (image != null && (file = image.asFileImage()) != null && (uri = shareContent.getFileUri(this.mAppContext, file, this.mFileProvider)) != null) {
                imageUri = Uri.parse((String)uri);
            }
            String pkg = "com.tencent.mm";
            shareIntent.setPackage(pkg);
            if (SHARE_MEDIA.WEIXIN.equals((Object)this.mTarget)) {
                if (imageUri != null) {
                    shareIntent.putExtra("android.intent.extra.STREAM", imageUri);
                    shareIntent.setType("image/*");
                } else {
                    if (TextUtils.isEmpty((CharSequence)text)) {
                        this.runInMainThread(new Runnable(){

                            @Override
                            public void run() {
                                UMWXHandler.this.umShareListener.onError(SHARE_MEDIA.WEIXIN, (Throwable)new Exception("content empty!"));
                            }
                        });
                        return false;
                    }
                    shareIntent.setType("text/plain");
                }
                cn = new ComponentName(pkg, "com.tencent.mm.ui.tools.ShareImgUI");
                shareIntent.setComponent(cn);
                this.mAppContext.startActivity(shareIntent);
                this.runInMainThread(new Runnable(){

                    @Override
                    public void run() {
                        UMWXHandler.this.umShareListener.onResult(SHARE_MEDIA.WEIXIN);
                    }
                });
                return true;
            }
            if (SHARE_MEDIA.WEIXIN_CIRCLE.equals((Object)this.mTarget)) {
                if (imageUri == null) {
                    this.runInMainThread(new Runnable(){

                        @Override
                        public void run() {
                            UMWXHandler.this.umShareListener.onError(SHARE_MEDIA.WEIXIN, (Throwable)new Exception("image empty!"));
                        }
                    });
                    return false;
                }
                shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imageUri);
                shareIntent.setType("image/*");
                cn = new ComponentName(pkg, "com.tencent.mm.ui.tools.ShareToTimeLineUI");
                shareIntent.setComponent(cn);
                this.mAppContext.startActivity(shareIntent);
                this.runInMainThread(new Runnable(){

                    @Override
                    public void run() {
                        UMWXHandler.this.umShareListener.onResult(SHARE_MEDIA.WEIXIN_CIRCLE);
                    }
                });
                return true;
            }
            this.runInMainThread(new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.umShareListener.onError(SHARE_MEDIA.WEIXIN, (Throwable)new Exception("Not Support!"));
                }
            });
            return false;
        }
        boolean useFileProvider = false;
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = this.buildTransaction(shareContent.getStrStyle());
        if (this.checkVersionValid() && this.checkAndroidNotBelowN()) {
            useFileProvider = true;
        }
        req.message = shareContent.getWxMediaMessage(this.mAppContext, useFileProvider, this.mFileProvider);
        switch (this.mTarget) {
            case WEIXIN: {
                req.scene = 0;
                break;
            }
            case WEIXIN_CIRCLE: {
                req.scene = 1;
                break;
            }
            case WEIXIN_FAVORITE: {
                req.scene = 2;
                break;
            }
            default: {
                req.scene = 2;
            }
        }
        if (req.message == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getShareListener(UMWXHandler.this.umShareListener).onError(UMWXHandler.this.mTarget, new Throwable(UmengErrorCode.UnKnowCode.getMessage() + "message = null"));
                }
            });
            return false;
        }
        if (req.message.mediaObject == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getShareListener(UMWXHandler.this.umShareListener).onError(UMWXHandler.this.mTarget, new Throwable(UmengErrorCode.UnKnowCode.getMessage() + "mediaobject = null"));
                }
            });
            return false;
        }
        boolean sendReq = this.mWXApi.sendReq((BaseReq)req);
        if (!sendReq) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMWXHandler.this.getShareListener(UMWXHandler.this.umShareListener).onError(UMWXHandler.this.mTarget, new Throwable(UmengErrorCode.UnKnowCode.getMessage() + UmengText.SHARE.SHARE_CONTENT_FAIL));
                }
            });
        }
        return sendReq;
    }

    protected void onShareCallback(SendMessageToWX.Resp resp) {
        switch (resp.errCode) {
            case 0: {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("uid", resp.openId);
                this.getShareListener(this.umShareListener).onResult(this.mTarget);
                break;
            }
            case -2: {
                this.getShareListener(this.umShareListener).onCancel(this.mTarget);
                break;
            }
            case -3: 
            case -1: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + resp.errStr));
                break;
            }
            case -6: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + UmengText.errorWithUrl((String)UmengText.AUTH.AUTH_DENIED, (String)UrlUtil.WX_ERROR_SIGN)));
                break;
            }
            case -5: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + UmengText.SHARE.VERSION_NOT_SUPPORT));
                break;
            }
            default: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + "code:" + resp.errCode + "msg:" + resp.errStr));
            }
        }
    }

    public IWXAPIEventHandler getWXEventHandler() {
        return this.mEventHandler;
    }

    public IWXAPI getWXApi() {
        return this.mWXApi;
    }

    private String buildTransaction(String type) {
        return type == null ? String.valueOf(System.currentTimeMillis()) : type + System.currentTimeMillis();
    }

    private boolean isAuthValid() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.isAuthValid();
        }
        return false;
    }

    private boolean isAccessTokenAvailable() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.isAccessTokenAvailable();
        }
        return false;
    }

    private void weixinPreferencesDelete() {
        if (this.weixinPreferences != null) {
            this.weixinPreferences.delete();
        }
    }

    private String getRefreshToken() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.getRefreshToken();
        }
        return "";
    }

    private String getOpenid() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.getOpenid();
        }
        return "";
    }

    private String getUid() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.getUID();
        }
        return "";
    }

    private String getAccessToken() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.getAccessToken();
        }
        return "";
    }

    private long getAccessTokenTTL() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.getAccessTokenTTL();
        }
        return 0L;
    }

    private void setBundle(Bundle bundle) {
        if (this.weixinPreferences != null) {
            this.weixinPreferences.setBundle(bundle).commit();
        }
    }

    private Map<String, String> getMap() {
        if (this.weixinPreferences != null) {
            return this.weixinPreferences.getMap();
        }
        return null;
    }

    public void release() {
        super.release();
        this.mAuthListener = null;
    }
}

