/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WbAuthListener;
import com.sina.weibo.sdk.common.UiError;
import com.sina.weibo.sdk.openapi.IWBAPI;
import com.sina.weibo.sdk.openapi.SdkListener;
import com.sina.weibo.sdk.openapi.WBAPIFactory;
import com.sina.weibo.sdk.share.WbShareCallback;
import com.umeng.commonsdk.debug.UMRTLog;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.SinaPreferences;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.SinaShareContent;
import com.umeng.socialize.net.DeleteRequest;
import com.umeng.socialize.net.DeleteResponse;
import com.umeng.socialize.net.UserinfoRequest;
import com.umeng.socialize.net.UserinfoResponse;
import com.umeng.socialize.net.base.SocializeClient;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import java.lang.ref.WeakReference;
import java.util.Map;

public class SinaSsoHandler
extends UMSSOHandler {
    private static final String TAG = "SinaSsoHandler";
    private static final int REQUEST_CODE = 10001;
    private PlatformConfig.APPIDPlatform config = null;
    private SinaPreferences sinaPreferences;
    private UMShareListener shareListener;
    private ShareListener mShareListener;
    private String mFileProvider;
    UMAuthListener umAuthListener;
    private Context mAppContext;
    private Activity activity;
    private boolean startAuthRequest = false;
    protected String VERSION = "7.3.7";
    private AuthInfo mAuthInfo;
    private static final String SCOPE = "email,direct_messages_read,direct_messages_write,friendships_groups_read,friendships_groups_write,statuses_to_me_read,follow_app_official_microblog,invitation_write";
    private IWBAPI mWBAPI;
    private WeiboMultiMessage message;
    private static final String REQUEST_USERINFO = "https://api.weibo.com/2/users/show.json";
    private static final String USERNAME = "userName";
    private boolean mWBinit = false;
    private boolean ShareTag = false;
    private boolean LoginTag = false;
    public ShareContent shareContent = new ShareContent();
    WeakReference<Activity> mActivityStack;

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mAppContext = context.getApplicationContext();
        this.config = (PlatformConfig.APPIDPlatform)p;
        if (TextUtils.isEmpty((CharSequence)this.config.getFileProvider())) {
            SLog.E((String)UmengText.SINA.SINA_FILE_PROVIDER_ERROR);
        } else {
            this.mFileProvider = this.config.getFileProvider();
        }
        this.sinaPreferences = new SinaPreferences(context, "sina");
        this.mAuthInfo = new AuthInfo(context, ((PlatformConfig.APPIDPlatform)p).appId, ((PlatformConfig.APPIDPlatform)this.getConfig()).redirectUrl, SCOPE);
        if (!(context instanceof Activity)) {
            return;
        }
        this.activity = (Activity)context;
        this.mActivityStack = new WeakReference<Activity>(this.activity);
        this.mWBAPI = WBAPIFactory.createWBAPI((Context)context);
        this.mWBAPI.registerApp(context, this.mAuthInfo, new SdkListener(){

            public void onInitSuccess() {
                SinaSsoHandler.this.mWBinit = true;
                if (SinaSsoHandler.this.ShareTag) {
                    SinaSsoHandler.this.ShareTag = false;
                    SinaSsoHandler.this.share(SinaSsoHandler.this.shareContent, SinaSsoHandler.this.shareListener);
                }
                if (SinaSsoHandler.this.LoginTag) {
                    SinaSsoHandler.this.LoginTag = false;
                    SinaSsoHandler.this.authorize(SinaSsoHandler.this.umAuthListener);
                }
            }

            public void onInitFailure(Exception e) {
                SinaSsoHandler.this.mWBinit = false;
            }
        });
    }

    public String getVersion() {
        return this.VERSION;
    }

    public IWBAPI getWbHandler() {
        return this.mWBAPI;
    }

    public WeiboMultiMessage getMessage() {
        return this.message;
    }

    public boolean isInstall() {
        return this.isClientInstalled();
    }

    public boolean isAuthorize() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.isAuthorized();
        }
        return false;
    }

    private boolean isClientInstalled() {
        boolean isWBAppInstalled = this.mWBAPI.isWBAppInstalled();
        return isWBAppInstalled;
    }

    public boolean isSupport() {
        return true;
    }

    public String getSDKVersion() {
        return "11.11.1";
    }

    public void authorize(UMAuthListener listener) {
        if (this.mWBinit) {
            AuthListener mAuthListener = new AuthListener(listener);
            if (this.mWBAPI != null) {
                if (this.getShareConfig().isSinaAuthWithWebView()) {
                    this.startAuthRequest = true;
                    UMRTLog.i((String)"MobclickRT", (String)"--->>> SINA:authorize: authorizeWeb");
                    this.mWBAPI.authorizeWeb(this.activity, (WbAuthListener)mAuthListener);
                } else {
                    this.startAuthRequest = true;
                    UMRTLog.i((String)"MobclickRT", (String)"--->>> SINA:authorize: authorize");
                    this.mWBAPI.authorize(this.activity, (WbAuthListener)mAuthListener);
                }
            }
        } else {
            this.LoginTag = true;
            this.umAuthListener = listener;
        }
    }

    private void userinfo(final UMAuthListener listener) {
        UserinfoRequest request = new UserinfoRequest(this.getUID(), this.getmAccessToken(), this.config.appId);
        UserinfoResponse response = (UserinfoResponse)new SocializeClient().execute((URequest)request);
        if (response == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed + UmengText.SINA.SINA_GET_ERROR));
                }
            });
            return;
        }
        final Map<String, String> map = response.result;
        if (map != null && !map.containsKey("error")) {
            map.put("iconurl", map.get("profile_image_url"));
            map.put("name", map.get("screen_name"));
            map.put("gender", this.getGender(map.get("gender")));
            if (this.sinaPreferences != null) {
                map.put("uid", this.sinaPreferences.getUID());
                map.put("access_token", this.sinaPreferences.getmAccessToken());
                map.put("refreshToken", this.sinaPreferences.getmRefreshToken());
                map.put("expires_in", String.valueOf(this.sinaPreferences.getmTTL()));
                map.put("accessToken", this.sinaPreferences.getmAccessToken());
                map.put("refreshToken", this.sinaPreferences.getmRefreshToken());
                map.put("expiration", String.valueOf(this.sinaPreferences.getmTTL()));
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onComplete(SHARE_MEDIA.SINA, 2, map);
                    }
                });
            }
        } else if (map != null) {
            if (this.sinaPreferences != null) {
                this.sinaPreferences.delete();
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed + ((String)map.get("error")).toString()));
                }
            });
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed + UmengText.AUTH.DATA_EMPTY));
                }
            });
        }
    }

    public void getPlatformInfo(UMAuthListener listener) {
        if (!this.getShareConfig().isNeedAuthOnGetUserInfo() && this.sinaPreferences.isAuthValid()) {
            this.userinfo(listener);
        } else {
            this.authAndFetchUserInfo(listener);
        }
    }

    private void authAndFetchUserInfo(final UMAuthListener listener) {
        this.authorize(new UMAuthListener(){

            public void onStart(SHARE_MEDIA platform) {
            }

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                QueuedWork.runInBack((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SinaSsoHandler.this.userinfo(listener);
                    }
                }, (boolean)false);
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                listener.onError(platform, action, t);
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
                listener.onCancel(platform, action);
            }
        });
    }

    private String getUID() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getUID();
        }
        return "";
    }

    private String getmAccessToken() {
        if (this.sinaPreferences != null) {
            if (this.sinaPreferences.getmAccessToken() != null) {
                return this.sinaPreferences.getmAccessToken();
            }
            return "";
        }
        return "";
    }

    private String getmRefreshToken() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getmRefreshToken();
        }
        return "";
    }

    private long getmTTL() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getmTTL();
        }
        return 0L;
    }

    public void deleteAuth(final UMAuthListener listener) {
        DeleteRequest request = new DeleteRequest(this.config.appId, this.getmAccessToken());
        if (this.sinaPreferences != null) {
            this.sinaPreferences.delete();
        }
        DeleteResponse response = (DeleteResponse)new SocializeClient().execute((URequest)request);
        if (this.sinaPreferences != null) {
            this.sinaPreferences.delete();
        }
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                listener.onComplete(SinaSsoHandler.this.getConfig().getName(), 1, null);
            }
        });
    }

    public boolean checkAndroidNotBelowN() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        if (this.mWBinit) {
            Log.e((String)"UMRTLog.RTLOG_TAG", (String)"\u5206\u4eab\u4e2d");
            boolean useFileProvider = false;
            if (this.checkAndroidNotBelowN()) {
                useFileProvider = true;
            }
            SinaShareContent mSharecontent = new SinaShareContent(content);
            if (this.mShareConfig != null) {
                mSharecontent.setCompressListener(this.mShareConfig.getCompressListener());
            }
            mSharecontent.setSupport(this.mWBAPI.isWBAppSupportMultipleImage());
            this.message = mSharecontent.getMessage(this.mAppContext, useFileProvider, this.mFileProvider);
            this.shareListener = listener;
            this.mShareListener = new ShareListener(this.shareListener);
            this.startAuthRequest = false;
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing() && this.mWBAPI != null) {
                UMRTLog.i((String)"MobclickRT", (String)"--->>> SINA: share");
                this.mWBAPI.shareMessage(this.activity, this.message, false);
            }
            return true;
        }
        this.ShareTag = true;
        this.shareContent = content;
        this.shareListener = listener;
        return false;
    }

    private void setAuthData(Bundle bundle) {
        if (this.sinaPreferences != null) {
            this.sinaPreferences.setAuthData(bundle).commit();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mWBAPI != null && this.getActivity()) {
            if (this.startAuthRequest) {
                UMRTLog.i((String)"MobclickRT", (String)"--->>> SINA:onActivityResult:auth callback.");
                this.mWBAPI.authorizeCallback(this.activity, requestCode, resultCode, data);
            } else {
                UMRTLog.i((String)"MobclickRT", (String)"--->>> SINA:onActivityResult:share callback.");
                this.mWBAPI.doResultIntent(data, (WbShareCallback)this.mShareListener);
            }
        }
        this.mWBAPI = null;
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        return 10001;
    }

    private Bundle tokenToBundle(Oauth2AccessToken oauth2AccessToken) {
        Bundle bundle = new Bundle();
        bundle.putString(USERNAME, oauth2AccessToken.getUid());
        bundle.putString("uid", oauth2AccessToken.getUid());
        bundle.putString("access_token", oauth2AccessToken.getAccessToken());
        bundle.putString("refresh_token", oauth2AccessToken.getRefreshToken());
        bundle.putString("expires_in", oauth2AccessToken.getExpiresTime() + "");
        return bundle;
    }

    public void release() {
        super.release();
        this.mWBAPI = null;
        this.activity = null;
    }

    public boolean getActivity() {
        Activity activity = null;
        if (this.mActivityStack != null) {
            activity = (Activity)this.mActivityStack.get();
        }
        return activity != null;
    }

    class AuthListener
    implements WbAuthListener {
        private UMAuthListener mListener = null;

        AuthListener(UMAuthListener listener) {
            this.mListener = listener;
        }

        public void onComplete(Oauth2AccessToken oauth2AccessToken) {
            Bundle values = SinaSsoHandler.this.tokenToBundle(oauth2AccessToken);
            SinaSsoHandler.this.setAuthData(values);
            if (this.mListener != null) {
                values.putString("aid", ((SinaSsoHandler)SinaSsoHandler.this).config.appId);
                values.putString("as", ((SinaSsoHandler)SinaSsoHandler.this).config.appkey);
                values.putString("name", values.getString(SinaSsoHandler.USERNAME));
                values.putString("accessToken", values.getString("access_token"));
                values.putString("refreshToken", values.getString("refresh_token"));
                values.putString("expiration", values.getString("expires_in"));
                this.mListener.onComplete(SHARE_MEDIA.SINA, 0, SocializeUtils.bundleTomap((Bundle)values));
                SinaSsoHandler.this.startAuthRequest = false;
            }
        }

        public void onCancel() {
            if (this.mListener != null) {
                this.mListener.onCancel(SHARE_MEDIA.SINA, 0);
                SinaSsoHandler.this.startAuthRequest = false;
            }
        }

        public void onError(UiError error) {
            if (this.mListener != null) {
                this.mListener.onError(SHARE_MEDIA.SINA, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + error.errorMessage));
                SinaSsoHandler.this.startAuthRequest = false;
            }
        }
    }

    class ShareListener
    implements WbShareCallback {
        private UMShareListener shareListenerInner = null;

        public ShareListener(UMShareListener listener) {
            this.shareListenerInner = listener;
        }

        public void onComplete() {
            if (this.shareListenerInner != null) {
                this.shareListenerInner.onResult(SHARE_MEDIA.SINA);
            }
        }

        public void onError(UiError uiError) {
            if (this.shareListenerInner != null) {
                String errorMsg = uiError.errorMessage;
                this.shareListenerInner.onError(SHARE_MEDIA.SINA, new Throwable(UmengErrorCode.ShareFailed.getMessage() + errorMsg));
            }
        }

        public void onCancel() {
            if (this.shareListenerInner != null) {
                this.shareListenerInner.onCancel(SHARE_MEDIA.SINA);
            }
        }
    }
}

