/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.view.WindowInsets;
import com.umeng.socialize.shareboard.widgets.WindowInsetsCompat;

class ViewCompat {
    private static final long FAKE_FRAME_TIME = 10L;
    private static final ViewCompatImpl IMPL;

    ViewCompat() {
    }

    static void postInvalidateOnAnimation(View view) {
        IMPL.postInvalidateOnAnimation(view);
    }

    static void postOnAnimation(View view, Runnable runnable) {
        IMPL.postOnAnimation(view, runnable);
    }

    static boolean canScrollHorizontally(View view, int n) {
        return IMPL.canScrollHorizontally(view, n);
    }

    public static void setOnApplyWindowInsetsListener(View view, OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
        IMPL.setOnApplyWindowInsetsListener(view, onApplyWindowInsetsListener);
    }

    public static WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
        return IMPL.onApplyWindowInsets(view, windowInsetsCompat);
    }

    public static WindowInsetsCompat dispatchApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
        return IMPL.dispatchApplyWindowInsets(view, windowInsetsCompat);
    }

    static {
        int n = Build.VERSION.SDK_INT;
        IMPL = n >= 24 ? new Api24ViewCompatImpl() : (n >= 23 ? new MarshmallowViewCompatImpl() : (n >= 21 ? new LollipopViewCompatImpl() : (n >= 19 ? new KitKatViewCompatImpl() : (n >= 18 ? new JbMr2ViewCompatImpl() : (n >= 17 ? new JbMr1ViewCompatImpl() : (n >= 16 ? new JBViewCompatImpl() : (n >= 15 ? new ICSMr1ViewCompatImpl() : (n >= 14 ? new ICSViewCompatImpl() : (n >= 11 ? new HCViewCompatImpl() : new BaseViewCompatImpl())))))))));
    }

    private static class Api24ViewCompatImpl
    extends MarshmallowViewCompatImpl {
        private Api24ViewCompatImpl() {
        }
    }

    private static class MarshmallowViewCompatImpl
    extends LollipopViewCompatImpl {
        private MarshmallowViewCompatImpl() {
        }
    }

    @TargetApi(value=20)
    private static class LollipopViewCompatImpl
    extends KitKatViewCompatImpl {
        private LollipopViewCompatImpl() {
        }

        @Override
        public void setOnApplyWindowInsetsListener(View view, final OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
            if (onApplyWindowInsetsListener == null) {
                view.setOnApplyWindowInsetsListener(null);
                return;
            }
            final OnApplyWindowInsetsListenerBridge onApplyWindowInsetsListenerBridge = new OnApplyWindowInsetsListenerBridge(){

                @Override
                public Object onApplyWindowInsets(View view, Object object) {
                    WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.wrap(object);
                    windowInsetsCompat = onApplyWindowInsetsListener.onApplyWindowInsets(view, windowInsetsCompat);
                    return WindowInsetsCompat.unwrap(windowInsetsCompat);
                }
            };
            view.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
                    return (WindowInsets)onApplyWindowInsetsListenerBridge.onApplyWindowInsets(view, windowInsets);
                }
            });
        }

        @Override
        public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
            return WindowInsetsCompat.wrap(LollipopViewCompatImpl.onApplyWindowInsets(view, WindowInsetsCompat.unwrap(windowInsetsCompat)));
        }

        private static Object onApplyWindowInsets(View view, Object object) {
            WindowInsets windowInsets = (WindowInsets)object;
            WindowInsets windowInsets2 = view.onApplyWindowInsets(windowInsets);
            if (windowInsets2 != windowInsets) {
                object = new WindowInsets(windowInsets2);
            }
            return object;
        }

        @Override
        public WindowInsetsCompat dispatchApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
            return WindowInsetsCompat.wrap(LollipopViewCompatImpl.dispatchApplyWindowInsets(view, WindowInsetsCompat.unwrap(windowInsetsCompat)));
        }

        private static Object dispatchApplyWindowInsets(View view, Object object) {
            WindowInsets windowInsets = (WindowInsets)object;
            WindowInsets windowInsets2 = view.dispatchApplyWindowInsets(windowInsets);
            if (windowInsets2 != windowInsets) {
                object = new WindowInsets(windowInsets2);
            }
            return object;
        }
    }

    private static class KitKatViewCompatImpl
    extends JbMr2ViewCompatImpl {
        private KitKatViewCompatImpl() {
        }
    }

    private static class JbMr2ViewCompatImpl
    extends JbMr1ViewCompatImpl {
        private JbMr2ViewCompatImpl() {
        }
    }

    private static class JbMr1ViewCompatImpl
    extends JBViewCompatImpl {
        private JbMr1ViewCompatImpl() {
        }
    }

    @TargetApi(value=16)
    static class JBViewCompatImpl
    extends ICSMr1ViewCompatImpl {
        JBViewCompatImpl() {
        }

        @Override
        public void postInvalidateOnAnimation(View view) {
            view.postInvalidateOnAnimation();
        }

        @Override
        public void postOnAnimation(View view, Runnable runnable) {
            view.postOnAnimation(runnable);
        }
    }

    static class ICSMr1ViewCompatImpl
    extends ICSViewCompatImpl {
        ICSMr1ViewCompatImpl() {
        }
    }

    @TargetApi(value=14)
    static class ICSViewCompatImpl
    extends HCViewCompatImpl {
        ICSViewCompatImpl() {
        }

        @Override
        public boolean canScrollHorizontally(View view, int n) {
            return view.canScrollHorizontally(n);
        }
    }

    @TargetApi(value=11)
    static class HCViewCompatImpl
    extends BaseViewCompatImpl {
        HCViewCompatImpl() {
        }

        @Override
        long getFrameTime() {
            return ValueAnimator.getFrameDelay();
        }
    }

    static class BaseViewCompatImpl
    implements ViewCompatImpl {
        BaseViewCompatImpl() {
        }

        @Override
        public boolean canScrollHorizontally(View view, int n) {
            return false;
        }

        @Override
        public void postInvalidateOnAnimation(View view) {
            view.invalidate();
        }

        @Override
        public void postOnAnimation(View view, Runnable runnable) {
            view.postDelayed(runnable, this.getFrameTime());
        }

        @Override
        public void setOnApplyWindowInsetsListener(View view, OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
        }

        long getFrameTime() {
            return 10L;
        }

        @Override
        public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
            return windowInsetsCompat;
        }

        @Override
        public WindowInsetsCompat dispatchApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
            return windowInsetsCompat;
        }
    }

    static interface ViewCompatImpl {
        public boolean canScrollHorizontally(View var1, int var2);

        public void postInvalidateOnAnimation(View var1);

        public void postOnAnimation(View var1, Runnable var2);

        public void setOnApplyWindowInsetsListener(View var1, OnApplyWindowInsetsListener var2);

        public WindowInsetsCompat onApplyWindowInsets(View var1, WindowInsetsCompat var2);

        public WindowInsetsCompat dispatchApplyWindowInsets(View var1, WindowInsetsCompat var2);
    }

    static interface OnApplyWindowInsetsListenerBridge {
        public Object onApplyWindowInsets(View var1, Object var2);
    }

    static interface OnApplyWindowInsetsListener {
        public WindowInsetsCompat onApplyWindowInsets(View var1, WindowInsetsCompat var2);
    }
}

