/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.umeng.socialize.shareboard.IndicatorView;
import com.umeng.socialize.shareboard.ShareBoardConfig;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.SocializeMenuAdapter;
import com.umeng.socialize.shareboard.SocializeMenuPagerAdapter;
import com.umeng.socialize.shareboard.widgets.SocializeViewPager;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;

class UMActionFrame
extends LinearLayout {
    private ShareBoardConfig mConfig;
    private PopupWindow.OnDismissListener mDismissListener;

    public UMActionFrame(Context context) {
        super(context);
    }

    public UMActionFrame(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @TargetApi(value=11)
    public UMActionFrame(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @TargetApi(value=21)
    public UMActionFrame(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    public void setSnsPlatformData(List<SnsPlatform> list) {
        ShareBoardConfig shareBoardConfig = new ShareBoardConfig();
        this.setSnsPlatformData(list, shareBoardConfig);
    }

    public void setSnsPlatformData(List<SnsPlatform> list, ShareBoardConfig shareBoardConfig) {
        this.mConfig = shareBoardConfig == null ? new ShareBoardConfig() : shareBoardConfig;
        this.init(list);
    }

    private void init(List<SnsPlatform> list) {
        this.setBackgroundColor(Color.argb((int)50, (int)0, (int)0, (int)0));
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(100L);
        this.setAnimation((Animation)alphaAnimation);
        this.setOrientation(1);
        if (this.mConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_BOTTOM) {
            this.setGravity(80);
        } else if (this.mConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_CENTER) {
            this.setGravity(17);
            int n = this.dip2px(36.0f);
            this.setPadding(n, 0, n, 0);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (UMActionFrame.this.mDismissListener != null) {
                    UMActionFrame.this.mDismissListener.onDismiss();
                }
            }
        });
        View view = this.createShareboardLayout(list);
        if (view == null) {
            return;
        }
        view.setClickable(true);
        this.addView(view);
    }

    private View createShareboardLayout(List<SnsPlatform> list) {
        Object object;
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setBackgroundColor(this.mConfig.mShareboardBgColor);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        if (this.mConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_CENTER && this.mConfig.mTopMargin != 0) {
            layoutParams.topMargin = this.mConfig.mTopMargin;
        }
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mConfig.mTitleVisibility) {
            View view = this.createShareTitle();
            linearLayout.addView(view);
        }
        int n = this.mConfig.calculateMenuHeightInDp(list.size());
        ViewPager viewPager = this.createViewPagerInstance();
        if (viewPager != null) {
            IndicatorView indicatorView;
            object = new SocializeMenuPagerAdapter(this.getContext(), this.mConfig);
            ((SocializeMenuPagerAdapter)((Object)object)).setData(list);
            this.settingMenuLayout((View)viewPager, n);
            linearLayout.addView((View)viewPager);
            viewPager.setAdapter((PagerAdapter)object);
            IndicatorView indicatorView2 = indicatorView = this.mConfig.mIndicatorVisibility ? this.createIndicatorView() : null;
            if (indicatorView != null) {
                indicatorView.setPageCount(((SocializeMenuPagerAdapter)((Object)object)).getCount());
                linearLayout.addView((View)indicatorView);
            }
            ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int n, float f2, int n2) {
                }

                public void onPageSelected(int n) {
                    if (indicatorView != null) {
                        indicatorView.setSelectedPosition(n);
                    }
                }

                public void onPageScrollStateChanged(int n) {
                }
            };
            if (this.verifyMethodExists()) {
                viewPager.addOnPageChangeListener(onPageChangeListener);
            } else {
                viewPager.setOnPageChangeListener(onPageChangeListener);
            }
        } else {
            IndicatorView indicatorView;
            object = this.createSocializeViewPagerInstance();
            if (object == null) {
                return null;
            }
            SocializeMenuAdapter socializeMenuAdapter = new SocializeMenuAdapter(this.getContext(), this.mConfig);
            socializeMenuAdapter.setData(list);
            this.settingMenuLayout((View)object, n);
            linearLayout.addView((View)object);
            object.setAdapter(socializeMenuAdapter);
            IndicatorView indicatorView3 = indicatorView = this.mConfig.mIndicatorVisibility ? this.createIndicatorView() : null;
            if (indicatorView != null) {
                indicatorView.setPageCount(socializeMenuAdapter.getCount());
                linearLayout.addView((View)indicatorView);
            }
            object.addOnPageChangeListener(new SocializeViewPager.OnPageChangeListener(){

                @Override
                public void onPageScrolled(int n, float f2, int n2) {
                }

                @Override
                public void onPageSelected(int n) {
                    if (indicatorView != null) {
                        indicatorView.setSelectedPosition(n);
                    }
                }

                @Override
                public void onPageScrollStateChanged(int n) {
                }
            });
        }
        if (this.mConfig.mCancelBtnVisibility) {
            object = this.createCancelBtn();
            linearLayout.addView((View)object);
        }
        return linearLayout;
    }

    private View createShareTitle() {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.mConfig.mTitleText);
        textView.setTextColor(this.mConfig.mTitleTextColor);
        textView.setTextSize(16.0f);
        textView.setGravity(17);
        textView.setMaxLines(1);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.topMargin = this.dip2px(20.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return textView;
    }

    private void settingMenuLayout(View view, int n) {
        int n2 = this.dip2px(20.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, this.dip2px(n));
        layoutParams.topMargin = n2;
        layoutParams.leftMargin = layoutParams.rightMargin = this.dip2px(10.0f);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        view.setPadding(0, 0, 0, n2);
    }

    public IndicatorView createIndicatorView() {
        int n = this.dip2px(20.0f);
        IndicatorView indicatorView = new IndicatorView(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.bottomMargin = n;
        indicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        indicatorView.setIndicatorColor(this.mConfig.mIndicatorNormalColor, this.mConfig.mIndicatorSelectedColor);
        indicatorView.setIndicator(3, 5);
        return indicatorView;
    }

    public View createCancelBtn() {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.mConfig.mCancelBtnText);
        textView.setTextColor(this.mConfig.mCancelBtnColor);
        textView.setClickable(true);
        textView.setTextSize(15.0f);
        textView.setGravity(17);
        if (this.mConfig.mCancelBtnBgPressedColor != 0) {
            if (Build.VERSION.SDK_INT >= 16) {
                textView.setBackground((Drawable)this.getBtnBg());
            } else {
                textView.setBackgroundDrawable((Drawable)this.getBtnBg());
            }
        } else {
            textView.setBackgroundColor(this.mConfig.mCancelBtnBgColor);
        }
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (UMActionFrame.this.mDismissListener != null) {
                    UMActionFrame.this.mDismissListener.onDismiss();
                }
            }
        });
        int n = this.dip2px(50.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, n);
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return textView;
    }

    private StateListDrawable getBtnBg() {
        ColorDrawable colorDrawable = new ColorDrawable(this.mConfig.mCancelBtnBgColor);
        ColorDrawable colorDrawable2 = new ColorDrawable(this.mConfig.mCancelBtnBgPressedColor);
        StateListDrawable stateListDrawable = new StateListDrawable();
        int n = 16842919;
        stateListDrawable.addState(new int[]{16842919}, (Drawable)colorDrawable2);
        stateListDrawable.addState(new int[0], (Drawable)colorDrawable);
        return stateListDrawable;
    }

    private int dip2px(float f2) {
        float f3 = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    void setDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    private ViewPager createViewPagerInstance() {
        ViewPager viewPager = null;
        try {
            Class<?> clazz = Class.forName("android.support.v4.view.ViewPager");
            Class[] classArray = new Class[]{Context.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.getContext()};
            viewPager = (ViewPager)constructor.newInstance(objectArray);
            return viewPager;
        }
        catch (Exception exception) {
            SLog.error(exception);
            return viewPager;
        }
    }

    private boolean verifyMethodExists() {
        try {
            Class<?> clazz = Class.forName("android.support.v4.view.ViewPager");
            Method method = clazz.getMethod("addOnPageChangeListener", ViewPager.OnPageChangeListener.class);
            if (method != null) {
                return true;
            }
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
        return false;
    }

    private SocializeViewPager createSocializeViewPagerInstance() {
        SocializeViewPager socializeViewPager = null;
        try {
            Class<?> clazz = Class.forName("com.umeng.socialize.shareboard.widgets.SocializeViewPager");
            Class[] classArray = new Class[]{Context.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.getContext()};
            socializeViewPager = (SocializeViewPager)((Object)constructor.newInstance(objectArray));
            return socializeViewPager;
        }
        catch (Exception exception) {
            SLog.error(UmengText.SHAREBOARD.NULLJAR, exception);
            return socializeViewPager;
        }
    }
}

