/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import android.net.Uri;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.net.utils.UResponse;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class UClient {
    private static final String TAG = "UClient";
    private static final String END = "\r\n";

    public <T extends UResponse> T execute(URequest uRequest, Class<T> clazz) {
        uRequest.onPrepareRequest();
        String string = uRequest.getHttpMethod().trim();
        this.verifyMethod(string);
        ResponseObj responseObj = null;
        if (URequest.GET.equals(string)) {
            responseObj = this.httpGetRequest(uRequest);
        } else if (URequest.POST.equals(string)) {
            responseObj = this.httpPostRequest(uRequest);
        }
        T t = this.createResponse(responseObj, clazz);
        return t;
    }

    protected <T extends UResponse> T createResponse(ResponseObj responseObj, Class<T> clazz) {
        if (responseObj == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(Integer.class, JSONObject.class);
            return (T)((UResponse)constructor.newInstance(responseObj.httpResponseCode, responseObj.jsonObject));
        }
        catch (Throwable throwable) {
            SLog.error(UmengText.NET.CREATE, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObj httpPostRequest(URequest uRequest) {
        String string5;
        InputStream inputStream;
        OutputStream outputStream;
        HttpURLConnection httpURLConnection;
        block26: {
            Object object;
            block27: {
                JSONObject jSONObject;
                String string2;
                String string3;
                String string4;
                block25: {
                    string4 = uRequest.toJson() == null ? "" : uRequest.toJson().toString();
                    string3 = UUID.randomUUID().toString();
                    httpURLConnection = null;
                    outputStream = null;
                    inputStream = null;
                    httpURLConnection = this.openUrlConnection(uRequest);
                    if (httpURLConnection != null) break block25;
                    ResponseObj responseObj = null;
                    this.closeQuietly(inputStream);
                    this.closeQuietly(outputStream);
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    return responseObj;
                }
                Map<String, Object> map = uRequest.getBodyPair();
                if (uRequest.mMimeType != null) {
                    string2 = (String)map.get("data");
                    httpURLConnection.setRequestProperty("Content-Type", uRequest.mMimeType.toString());
                    outputStream = httpURLConnection.getOutputStream();
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        outputStream.write(string2.getBytes());
                    }
                } else if (uRequest.postStyle == URequest.PostStyle.APPLICATION) {
                    httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    string2 = new Uri.Builder();
                    for (String string5 : map.keySet()) {
                        try {
                            string2.appendQueryParameter(string5, map.get(string5).toString());
                        }
                        catch (Throwable throwable) {
                            SLog.error(throwable);
                        }
                    }
                    object = string2.build().getEncodedQuery();
                    outputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        outputStream.write(((String)object).getBytes());
                    }
                } else if (map != null && map.size() > 0 || uRequest.postStyle == URequest.PostStyle.MULTIPART) {
                    httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
                    outputStream = httpURLConnection.getOutputStream();
                    this.addBodyParams(uRequest, outputStream, string3);
                } else {
                    httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    string2 = new Uri.Builder();
                    string2.appendQueryParameter("content", string4);
                    object = string2.build().getEncodedQuery();
                    outputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        outputStream.write(((String)object).getBytes());
                    }
                }
                outputStream.flush();
                int n = httpURLConnection.getResponseCode();
                object = new ResponseObj();
                ((ResponseObj)object).httpResponseCode = n;
                if (n != 200) break block26;
                inputStream = httpURLConnection.getInputStream();
                string5 = httpURLConnection.getContentEncoding();
                String string6 = this.convertStreamToString(this.wrapStream(string5, inputStream));
                if (!string6.startsWith("success") && !string6.startsWith("fail")) break block27;
                ((ResponseObj)object).jsonObject = jSONObject = new JSONObject("{\"result\":\"" + string6 + "\"}");
                Object object2 = object;
                this.closeQuietly(inputStream);
                this.closeQuietly(outputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return object2;
            }
            JSONObject jSONObject = this.parseResult(uRequest, httpURLConnection.getRequestMethod(), string5, inputStream);
            SLog.debug(UmengText.NET.POSTJSON + jSONObject);
            ((ResponseObj)object).jsonObject = jSONObject;
            Object object3 = object;
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return object3;
        }
        try {
            string5 = null;
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return string5;
        }
        catch (Throwable throwable) {
            try {
                SLog.error(UmengText.NET.PARSEERROR, throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.closeQuietly(inputStream);
                this.closeQuietly(outputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObj httpGetRequest(URequest uRequest) {
        HttpURLConnection httpURLConnection;
        InputStream inputStream;
        block12: {
            JSONObject jSONObject;
            block11: {
                inputStream = null;
                httpURLConnection = null;
                httpURLConnection = this.openUrlConnection(uRequest);
                if (httpURLConnection != null) break block11;
                ResponseObj responseObj = null;
                this.closeQuietly(inputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return responseObj;
            }
            int n = httpURLConnection.getResponseCode();
            ResponseObj responseObj = new ResponseObj();
            responseObj.httpResponseCode = n;
            if (n != 200) break block12;
            inputStream = httpURLConnection.getInputStream();
            String string = httpURLConnection.getContentEncoding();
            responseObj.jsonObject = jSONObject = this.parseResult(uRequest, httpURLConnection.getRequestMethod(), string, inputStream);
            SLog.debug(UmengText.NET.JSONRESULT);
            ResponseObj responseObj2 = responseObj;
            this.closeQuietly(inputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return responseObj2;
        }
        try {
            ResponseObj responseObj = null;
            this.closeQuietly(inputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return responseObj;
        }
        catch (Throwable throwable) {
            try {
                SLog.error(UmengText.NET.PARSEERROR, throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.closeQuietly(inputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return null;
    }

    private HttpURLConnection openUrlConnection(URequest uRequest) throws IOException {
        String string = uRequest.getHttpMethod().trim();
        String string2 = null;
        if (URequest.GET.equals(string)) {
            string2 = uRequest.toGetUrl();
        } else if (URequest.POST.equals(string)) {
            string2 = uRequest.mBaseUrl;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        URL uRL = new URL(string2);
        String string3 = uRL.getProtocol();
        boolean bl = false;
        if ("https".equals(string3)) {
            bl = true;
        }
        HttpURLConnection httpURLConnection = bl ? (HttpsURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(Config.connectionTimeOut);
        httpURLConnection.setReadTimeout(Config.readSocketTimeOut);
        httpURLConnection.setRequestMethod(string);
        if (URequest.GET.equals(string)) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
            if (uRequest.mHeaders != null && uRequest.mHeaders.size() > 0) {
                Set<String> set = uRequest.mHeaders.keySet();
                for (String string4 : set) {
                    httpURLConnection.setRequestProperty(string4, uRequest.mHeaders.get(string4));
                }
            }
        } else if (URequest.POST.equals(string)) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
        }
        return httpURLConnection;
    }

    private void verifyMethod(String string) {
        String string2 = string;
        if (TextUtils.isEmpty((CharSequence)string2) || URequest.GET.equals(string2.trim()) == URequest.POST.equals(string2.trim())) {
            throw new RuntimeException(UmengText.netMethodError(string2));
        }
    }

    private void addBodyParams(URequest uRequest, OutputStream outputStream, String string) throws IOException {
        Object object;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> map = uRequest.getBodyPair();
        Set<String> set = map.keySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (map.get(object) == null) continue;
            this.addFormField(stringBuilder, (String)object, map.get(object).toString(), string);
        }
        if (stringBuilder.length() > 0) {
            bl = true;
            outputStream = new DataOutputStream(outputStream);
            outputStream.write(stringBuilder.toString().getBytes());
        }
        if ((object2 = uRequest.getFilePair()) != null && object2.size() > 0) {
            object = object2.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                URequest.FilePair filePair = (URequest.FilePair)object2.get(string2);
                byte[] byArray = filePair.mBinaryData;
                if (byArray == null || byArray.length < 1) continue;
                bl = true;
                this.addFilePart(filePair.mFileName, byArray, string, outputStream);
            }
        }
        if (bl) {
            this.finishWrite(outputStream, string);
        }
    }

    private void addFormField(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append("--").append(string3).append(END).append("Content-Disposition: form-data; name=\"").append(string).append("\"").append(END).append("Content-Type: text/plain; charset=").append("UTF-8").append(END).append(END).append(string2).append(END);
    }

    private void addFilePart(String string, byte[] byArray, String string2, OutputStream outputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--").append(string2).append(END).append("Content-Disposition: form-data; name=\"").append("pic").append("\"; filename=\"").append(string).append("\"").append(END).append("Content-Type: ").append("application/octet-stream").append(END).append("Content-Transfer-Encoding: binary").append(END).append(END);
        outputStream.write(stringBuilder.toString().getBytes());
        outputStream.write(byArray);
        outputStream.write(END.getBytes());
    }

    private void finishWrite(OutputStream outputStream, String string) throws IOException {
        outputStream.write(END.getBytes());
        outputStream.write(("--" + string + "--").getBytes());
        outputStream.write(END.getBytes());
        outputStream.flush();
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected JSONObject parseResult(URequest uRequest, String string, String string2, InputStream inputStream) {
        block13: {
            InputStream inputStream2 = null;
            try {
                inputStream2 = this.wrapStream(string2, inputStream);
                String string3 = this.convertStreamToString(inputStream2);
                if ("POST".equals(string)) {
                    try {
                        JSONObject jSONObject = new JSONObject(string3);
                        return jSONObject;
                    }
                    catch (Throwable throwable) {
                        SLog.error(UmengText.NET.PARSEERROR, throwable);
                        JSONObject jSONObject = this.decryptData(uRequest, string3);
                        this.closeQuietly(inputStream2);
                        return jSONObject;
                    }
                }
                if ("GET".equals(string)) {
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        JSONObject jSONObject = null;
                        return jSONObject;
                    }
                    JSONObject jSONObject = this.decryptData(uRequest, string3);
                    return jSONObject;
                }
                break block13;
                {
                    catch (Throwable throwable) {
                        SLog.error(UmengText.NET.PARSEERROR, throwable);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeQuietly(inputStream2);
            }
        }
        return null;
    }

    protected InputStream wrapStream(String string, InputStream inputStream) throws IOException {
        if (string == null || "identity".equalsIgnoreCase(string)) {
            return inputStream;
        }
        if ("gzip".equalsIgnoreCase(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(string)) {
            return new InflaterInputStream(inputStream, new Inflater(false), 512);
        }
        throw new RuntimeException("unsupported content-encoding: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertStreamToString(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 512);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
        }
        catch (Throwable throwable) {
            SLog.error(UmengText.NET.TOOL, throwable);
            String string = null;
            return string;
        }
        finally {
            this.closeQuietly(inputStreamReader);
            this.closeQuietly(bufferedReader);
        }
        return stringBuilder.toString();
    }

    private JSONObject decryptData(URequest uRequest, String string) {
        try {
            String string2 = uRequest.getDecryptString(string);
            return new JSONObject(string2);
        }
        catch (Throwable throwable) {
            SLog.error(UmengText.NET.CREATE, throwable);
            return null;
        }
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            SLog.error(UmengText.NET.CLOSE, throwable);
        }
    }

    protected static class ResponseObj {
        public JSONObject jsonObject;
        public int httpResponseCode;

        protected ResponseObj() {
        }
    }
}

