/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.bytedance.sdk.open.aweme.authorize.model.Authorization;
import com.bytedance.sdk.open.aweme.common.handler.IApiEventHandler;
import com.bytedance.sdk.open.aweme.common.model.BaseReq;
import com.bytedance.sdk.open.aweme.common.model.BaseResp;
import com.bytedance.sdk.open.douyin.DouYinOpenApiFactory;
import com.bytedance.sdk.open.douyin.DouYinOpenConfig;
import com.bytedance.sdk.open.douyin.api.DouYinOpenApi;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.StringName;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.DouyinPreferences;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.DouyinShareContent;
import com.umeng.socialize.net.DYAuthUtils;
import com.umeng.socialize.net.DecryptMobile;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UMAuthUtils;
import com.umeng.socialize.utils.UmengText;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UMDYHandler
extends UMSSOHandler {
    private static final String TAG = "UMDYHandler";
    private static final int REFRESH_TOKEN_EXPIRES = 1296000;
    private static final int RESP_TYPE_AUTH = 2;
    private static final int RESP_TYPE_SHARE = 4;
    private static final int RESP_TYPE_SHARE_Friend = 6;
    private String VERSION = "7.3.7";
    private static String sScope = "snsapi_userinfo,snsapi_friend,snsapi_message";
    private PlatformConfig.APPIDPlatform config;
    private DouyinPreferences douyinPreferences;
    public UMAuthListener mAuthListener;
    private UMShareListener umShareListener;
    private SHARE_MEDIA mTarget = SHARE_MEDIA.BYTEDANCE;
    DouYinOpenApi douYinOpenApi;
    private ArrayList<String> mUri = new ArrayList();
    static final int PHOTO_REQUEST_GALLERY = 10;
    private Activity activity;
    private Context mAppContext;
    public static int ShareType = 0;
    private String mFileProvider;
    private static final String REFRESH_TOKEN_EXPIRES_KEY = "refresh_token_expires";
    private static final String NICKNAME = "nickname";
    private static final String LANGUAGE = "language";
    private static final String HEADIMGURL = "headimgurl";
    private static final String SEX = "sex";
    private static final String PRIVILEGE = "privilege";
    private static final String ERRORCODE = "errcode";
    private static final String ERRMSG = "errmsg";
    private static final String ERROR_CODE_TOKEN_FAIL = "40001";
    private static final String ERROR_CODE_TOKEN_REFESH_FAIL = "40030";
    private static final String ERROR_CODE_TOKEN_ACCESS_FAIL = "42002";
    private IApiEventHandler mEventHandler = new IApiEventHandler(){

        public void onReq(BaseReq baseReq) {
        }

        public void onResp(BaseResp baseResp) {
            int type = baseResp.getType();
            switch (type) {
                case 2: {
                    UMDYHandler.this.onAuthCallback((Authorization.Response)baseResp);
                    break;
                }
                case 4: {
                    UMDYHandler.this.onShareCallback(baseResp);
                    break;
                }
                case 6: {
                    UMDYHandler.this.onShareCallbackFriends(baseResp);
                    break;
                }
            }
        }

        public void onErrorIntent(Intent intent) {
        }
    };

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mAppContext = context.getApplicationContext();
        this.douyinPreferences = new DouyinPreferences(this.mAppContext, "douyin");
        this.config = (PlatformConfig.APPIDPlatform)p;
        if (!(context instanceof Activity)) {
            return;
        }
        this.activity = (Activity)context;
        DouYinOpenApiFactory.init((DouYinOpenConfig)new DouYinOpenConfig(this.config.appId));
        this.douYinOpenApi = DouYinOpenApiFactory.create((Activity)this.activity);
    }

    public String getVersion() {
        return this.VERSION;
    }

    public boolean isInstall() {
        return this.isClientInstalled();
    }

    private boolean isClientInstalled() {
        boolean isDYAppInstalled = this.douYinOpenApi.isAppInstalled();
        return isDYAppInstalled;
    }

    public void deleteAuth(final UMAuthListener listener) {
        this.douyinPreferencesDelete();
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UMDYHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.BYTEDANCE, 1, null);
            }
        });
    }

    private void douyinPreferencesDelete() {
        if (this.douyinPreferences != null) {
            this.douyinPreferences.delete();
        }
    }

    public boolean isSupport() {
        return true;
    }

    public IApiEventHandler getDYEventHandler() {
        return this.mEventHandler;
    }

    public DouYinOpenApi getDYapi() {
        return this.douYinOpenApi;
    }

    public void setAuthListener(UMAuthListener listener) {
        super.setAuthListener(listener);
        this.mAuthListener = listener;
    }

    public boolean isHasAuthListener() {
        return this.mAuthListener != null;
    }

    public void authorize(UMAuthListener listener) {
        if (this.config != null) {
            this.mTarget = this.config.getName();
        }
        this.mAuthListener = listener;
        Authorization.Request request = new Authorization.Request();
        request.scope = "user_info";
        request.optionalScope1 = "mobile";
        request.state = "ww";
        this.douYinOpenApi.authorize(request);
    }

    private void runInMainThread(Runnable runnable) {
        QueuedWork.runInMain((Runnable)runnable);
    }

    public boolean isAuthorize() {
        return this.douyinPreferences.isAuth();
    }

    private Bundle parseAuthData(String response) {
        Bundle bundle = new Bundle();
        if (TextUtils.isEmpty((CharSequence)response)) {
            return bundle;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            Iterator iterator = jsonObject.keys();
            String key = "";
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                bundle.putString(key, jsonObject.optString(key));
            }
        }
        catch (JSONException e) {
            SLog.error((Throwable)e);
        }
        return bundle;
    }

    private void onAuthCallback(Authorization.Response resp) {
        String url = "https://open.douyin.com/oauth/access_token/?client_key=" + this.config.click_key + "&client_secret=" + this.config.appkey + "&code=" + resp.authCode + "&grant_type=authorization_code";
        if (resp.errorCode == -2) {
            this.getAuthListener(this.mAuthListener).onCancel(SHARE_MEDIA.BYTEDANCE, 0);
        } else if (resp.errorCode == 0) {
            this.loadOauthData(url);
        }
    }

    private void loadOauthData(final String url) {
        QueuedWork.runInBack((Runnable)new Runnable(){

            @Override
            public void run() {
                block12: {
                    String response = DYAuthUtils.request(url);
                    JSONObject authStatusjsonObject = null;
                    try {
                        authStatusjsonObject = new JSONObject(response);
                        String data = authStatusjsonObject.getString("data");
                        authStatusjsonObject = new JSONObject(data);
                        if (!authStatusjsonObject.getString("error_code").equals("0")) break block12;
                        Bundle bundle = UMDYHandler.this.parseAuthData(data);
                        UMDYHandler.this.setBundle(bundle);
                        String url2 = "https://open.douyin.com/oauth/userinfo/?access_token=" + authStatusjsonObject.getString("access_token") + "&open_id=" + authStatusjsonObject.getString("open_id");
                        String userresponse = DYAuthUtils.request(url2);
                        authStatusjsonObject = new JSONObject(userresponse);
                        data = authStatusjsonObject.getString("data");
                        authStatusjsonObject = new JSONObject(data);
                        String loginCode = authStatusjsonObject.getString("error_code");
                        String description = authStatusjsonObject.getString("description");
                        if (loginCode.equals("0")) {
                            Map map = SocializeUtils.jsonToMap((String)data);
                            try {
                                String key = "encrypt_mobile";
                                String mobile = (String)map.remove(key);
                                if (!TextUtils.isEmpty((CharSequence)mobile)) {
                                    mobile = DecryptMobile.main(UMDYHandler.this.config.getAppSecret(), mobile);
                                    mobile = UMAuthUtils.encrypt((String)mobile, (String)UMDYHandler.this.config.getAppSecret());
                                    map.put(key, mobile);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            UMDYHandler.this.getAuthListener(UMDYHandler.this.mAuthListener).onComplete(SHARE_MEDIA.BYTEDANCE, 0, map);
                            break block12;
                        }
                        if (loginCode.equals("xxxxx")) {
                            UMDYHandler.this.getAuthListener(UMDYHandler.this.mAuthListener).onCancel(SHARE_MEDIA.BYTEDANCE, 0);
                        } else if (loginCode.equals("2100005")) {
                            UMDYHandler.this.getAuthListener(UMDYHandler.this.mAuthListener).onError(SHARE_MEDIA.BYTEDANCE, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + UmengText.errorWithUrl((String)UmengText.AUTH.AUTH_DENIED, (String)"Parameter error")));
                        } else if (loginCode.equals("xxxxx")) {
                            UMDYHandler.this.getAuthListener(UMDYHandler.this.mAuthListener).onCancel(SHARE_MEDIA.BYTEDANCE, 0);
                        } else {
                            CharSequence err = TextUtils.concat((CharSequence[])new CharSequence[]{"douyin auth error (", String.valueOf(loginCode), "):", description});
                            UMDYHandler.this.getAuthListener(UMDYHandler.this.mAuthListener).onError(SHARE_MEDIA.BYTEDANCE, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + err));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, (boolean)true);
    }

    private void setBundle(Bundle bundle) {
        if (this.douyinPreferences != null) {
            this.douyinPreferences.setBundle(bundle).commit();
        }
    }

    public String getSDKVersion() {
        return "3.1.1";
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        return 10086;
    }

    public void getPlatformInfo(final UMAuthListener listener) {
        if (this.getShareConfig().isNeedAuthOnGetUserInfo()) {
            // empty if block
        }
        this.authorize(new UMAuthListener(){

            public void onStart(SHARE_MEDIA platform) {
            }

            public void onComplete(final SHARE_MEDIA platform, final int action, final Map<String, String> data) {
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UMDYHandler.this.getAuthListener(listener).onComplete(platform, action, data);
                    }
                });
            }

            public void onError(final SHARE_MEDIA platform, final int action, final Throwable t) {
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UMDYHandler.this.getAuthListener(listener).onError(platform, action, t);
                    }
                });
            }

            public void onCancel(final SHARE_MEDIA platform, final int action) {
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UMDYHandler.this.getAuthListener(listener).onCancel(platform, action);
                    }
                });
            }
        });
    }

    public String getGender(Object object) {
        String male = StringName.male;
        String female = StringName.female;
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            if (object.equals("m") || object.equals("1") || object.equals(UmengText.MAN)) {
                return male;
            }
            if (object.equals("f") || object.equals("2") || object.equals(UmengText.WOMAN)) {
                return female;
            }
            return object.toString();
        }
        if (object instanceof Integer) {
            if ((Integer)object == 1) {
                return male;
            }
            if ((Integer)object == 2) {
                return female;
            }
            return object.toString();
        }
        return object.toString();
    }

    public boolean share(ShareContent sharecontent, UMShareListener listener) {
        if (this.config != null) {
            this.mTarget = this.config.getName();
        }
        boolean useFileProvider = false;
        if (this.checkAndroidNotBelowN()) {
            useFileProvider = true;
        }
        DouyinShareContent douyinShareContent = new DouyinShareContent(this.mAppContext, sharecontent, this.douYinOpenApi, useFileProvider, this.config.getFileProvider());
        douyinShareContent.setSupport(true);
        this.umShareListener = listener;
        if (this.mTarget == SHARE_MEDIA.BYTEDANCE) {
            ShareType = 0;
            this.douYinOpenApi.share(douyinShareContent.getMessage(this.mAppContext));
        } else if (this.mTarget == SHARE_MEDIA.BYTEDANCE_PUBLISH) {
            ShareType = 1;
            this.douYinOpenApi.share(douyinShareContent.getMessage(this.mAppContext));
        } else if (this.mTarget == SHARE_MEDIA.BYTEDANCE_FRIENDS) {
            ShareType = 2;
            if (this.douYinOpenApi.isAppSupportShareToContacts()) {
                this.douYinOpenApi.shareToContacts(douyinShareContent.getMessageFriends(this.mAppContext));
            }
        }
        return true;
    }

    protected void onShareCallback(BaseResp baseResp) {
        switch (baseResp.errorCode) {
            case 0: {
                this.getShareListener(this.umShareListener).onResult(this.mTarget);
                break;
            }
            case -2: {
                this.getShareListener(this.umShareListener).onCancel(this.mTarget);
                break;
            }
            case -3: 
            case -1: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + baseResp.errorMsg));
                break;
            }
            default: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + "code:" + baseResp.errorCode + "msg:" + baseResp.errorMsg));
            }
        }
    }

    protected void onShareCallbackFriends(BaseResp baseResp) {
        switch (baseResp.errorCode) {
            case 20000: {
                this.getShareListener(this.umShareListener).onResult(this.mTarget);
                break;
            }
            case 20004: 
            case 20013: {
                this.getShareListener(this.umShareListener).onCancel(this.mTarget);
                break;
            }
            case 20001: 
            case 20003: 
            case 20006: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + baseResp.errorMsg));
                break;
            }
            default: {
                this.getShareListener(this.umShareListener).onError(this.mTarget, new Throwable(UmengErrorCode.ShareFailed.getMessage() + "code:" + baseResp.errorCode + "msg:" + baseResp.errorMsg));
            }
        }
    }

    public boolean checkAndroidNotBelowN() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public void release() {
        super.release();
        this.mAuthListener = null;
        this.activity = null;
    }

    public SHARE_MEDIA getmTarget() {
        if (this.config != null) {
            this.mTarget = this.config.getName();
        }
        return this.mTarget;
    }

    private boolean isAuthValid() {
        if (this.douyinPreferences != null) {
            return this.douyinPreferences.isAuthValid();
        }
        return false;
    }
}

