/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.open.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.connect.auth.QQToken;
import com.tencent.open.a.f;
import com.tencent.open.a.g;
import com.tencent.open.b.h;
import com.tencent.open.log.SLog;
import com.tencent.open.log.d;
import com.tencent.open.utils.j;
import com.tencent.open.utils.k;
import com.tencent.open.utils.m;
import com.tencent.open.utils.n;
import com.tencent.tauth.IRequestListener;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.SyncFailedException;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.io.WriteAbortedException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLockInterruptionException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.zip.ZipException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtils {
    private HttpUtils() {
    }

    public static JSONObject request(QQToken qQToken, Context context, String string, Bundle bundle, String string2) throws IOException, JSONException, NetworkUnavailableException, HttpStatusException {
        SLog.i("openSDK_LOG.HttpUtils", "OpenApi request");
        if (!n.b(context)) {
            throw new NetworkUnavailableException("network unavailable");
        }
        String string3 = string;
        String string4 = string;
        if (!string.toLowerCase().startsWith("http")) {
            string3 = k.a().a(context, "https://openmobile.qq.com/") + string;
            string4 = k.a().a(context, "https://openmobile.qq.com/") + string;
        }
        HttpUtils.a(context, qQToken, string);
        JSONObject jSONObject = null;
        long l2 = SystemClock.elapsedRealtime();
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = 0;
        int n4 = j.a(context, qQToken.getAppId()).a("Common_HttpRetryCount");
        SLog.v("OpenConfig_test", "config 1:Common_HttpRetryCount            config_value:" + n4 + "   appid:" + qQToken.getAppId() + "     url:" + string4);
        n4 = n4 == 0 ? 3 : n4;
        SLog.v("OpenConfig_test", "config 1:Common_HttpRetryCount            result_value:" + n4 + "   appid:" + qQToken.getAppId() + "     url:" + string4);
        do {
            ++n3;
            try {
                g g2 = HttpUtils.a(string3, string2, bundle);
                int n5 = g2.d();
                SLog.i("openSDK_LOG.HttpUtils", "request statusCode " + n5);
                if (n5 != 200) {
                    n2 = n5;
                    l3 = 0L;
                    l4 = 0L;
                    h.a().a(string4, l2, l3, l4, n2);
                    throw new HttpStatusException(n5);
                }
                String string5 = g2.a();
                jSONObject = n.d(string5);
                try {
                    n2 = jSONObject.getInt("ret");
                }
                catch (JSONException jSONException) {
                    n2 = -4;
                }
                l3 = g2.c();
                l4 = g2.b();
                break;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                socketTimeoutException.printStackTrace();
                n2 = -8;
                l3 = 0L;
                l4 = 0L;
                if (n3 < n4) {
                    l2 = SystemClock.elapsedRealtime();
                    continue;
                }
                h.a().a(string4, l2, l3, l4, n2);
                throw socketTimeoutException;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                n2 = -3;
                l3 = 0L;
                l4 = 0L;
                h.a().a(string4, l2, l3, l4, n2);
                throw malformedURLException;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                n2 = HttpUtils.getErrorCodeFromException(iOException);
                l3 = 0L;
                l4 = 0L;
                h.a().a(string4, l2, l3, l4, n2);
                throw iOException;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                n2 = -4;
                l3 = 0L;
                l4 = 0L;
                h.a().a(string4, l2, l3, l4, n2);
                throw jSONException;
            }
        } while (n3 < n4);
        h.a().a(string4, l2, l3, l4, n2);
        return jSONObject;
    }

    public static void requestAsync(final QQToken qQToken, final Context context, final String string, final Bundle bundle, final String string2, final IRequestListener iRequestListener) {
        SLog.i("openSDK_LOG.HttpUtils", "OpenApi requestAsync");
        m.a(new Runnable(){

            @Override
            public void run() {
                block15: {
                    try {
                        JSONObject jSONObject = HttpUtils.request(qQToken, context, string, bundle, string2);
                        if (iRequestListener != null) {
                            iRequestListener.onComplete(jSONObject);
                            SLog.i("openSDK_LOG.HttpUtils", "OpenApi onComplete");
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (iRequestListener != null) {
                            iRequestListener.onMalformedURLException(malformedURLException);
                            SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync MalformedURLException" + malformedURLException.toString());
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        if (iRequestListener != null) {
                            iRequestListener.onSocketTimeoutException(socketTimeoutException);
                            SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync onSocketTimeoutException" + socketTimeoutException.toString());
                        }
                    }
                    catch (NetworkUnavailableException networkUnavailableException) {
                        if (iRequestListener != null) {
                            iRequestListener.onNetworkUnavailableException(networkUnavailableException);
                            SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync onNetworkUnavailableException" + networkUnavailableException.toString());
                        }
                    }
                    catch (HttpStatusException httpStatusException) {
                        if (iRequestListener != null) {
                            iRequestListener.onHttpStatusException(httpStatusException);
                            SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync onHttpStatusException" + httpStatusException.toString());
                        }
                    }
                    catch (IOException iOException) {
                        if (iRequestListener != null) {
                            iRequestListener.onIOException(iOException);
                            SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync IOException" + iOException.toString());
                        }
                    }
                    catch (JSONException jSONException) {
                        if (iRequestListener != null) {
                            iRequestListener.onJSONException(jSONException);
                            SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync JSONException" + jSONException.toString());
                        }
                    }
                    catch (Exception exception) {
                        if (iRequestListener == null) break block15;
                        iRequestListener.onUnknowException(exception);
                        SLog.e("openSDK_LOG.HttpUtils", "OpenApi requestAsync onUnknowException" + exception.toString());
                    }
                }
            }
        });
    }

    private static void a(Context context, QQToken qQToken, String string) {
        if (string.indexOf("add_share") > -1 || string.indexOf("upload_pic") > -1 || string.indexOf("add_topic") > -1 || string.indexOf("set_user_face") > -1 || string.indexOf("add_t") > -1 || string.indexOf("add_pic_t") > -1 || string.indexOf("add_pic_url") > -1 || string.indexOf("add_video") > -1) {
            com.tencent.connect.a.a.a(context, qQToken, "requireApi", string);
        }
    }

    public static int getErrorCodeFromException(IOException iOException) {
        if (iOException instanceof CharConversionException) {
            return -20;
        }
        if (iOException instanceof MalformedInputException) {
            return -21;
        }
        if (iOException instanceof UnmappableCharacterException) {
            return -22;
        }
        if (iOException instanceof ClosedChannelException) {
            return -24;
        }
        if (iOException instanceof EOFException) {
            return -26;
        }
        if (iOException instanceof FileLockInterruptionException) {
            return -27;
        }
        if (iOException instanceof FileNotFoundException) {
            return -28;
        }
        if (iOException instanceof HttpRetryException) {
            return -29;
        }
        if (iOException instanceof SocketTimeoutException) {
            return -8;
        }
        if (iOException instanceof InvalidPropertiesFormatException) {
            return -30;
        }
        if (iOException instanceof MalformedURLException) {
            return -3;
        }
        if (iOException instanceof InvalidClassException) {
            return -33;
        }
        if (iOException instanceof InvalidObjectException) {
            return -34;
        }
        if (iOException instanceof NotActiveException) {
            return -35;
        }
        if (iOException instanceof NotSerializableException) {
            return -36;
        }
        if (iOException instanceof OptionalDataException) {
            return -37;
        }
        if (iOException instanceof StreamCorruptedException) {
            return -38;
        }
        if (iOException instanceof WriteAbortedException) {
            return -39;
        }
        if (iOException instanceof ProtocolException) {
            return -40;
        }
        if (iOException instanceof SSLHandshakeException) {
            return -41;
        }
        if (iOException instanceof SSLKeyException) {
            return -42;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return -43;
        }
        if (iOException instanceof SSLProtocolException) {
            return -44;
        }
        if (iOException instanceof BindException) {
            return -45;
        }
        if (iOException instanceof ConnectException) {
            return -46;
        }
        if (iOException instanceof NoRouteToHostException) {
            return -47;
        }
        if (iOException instanceof PortUnreachableException) {
            return -48;
        }
        if (iOException instanceof SyncFailedException) {
            return -49;
        }
        if (iOException instanceof UTFDataFormatException) {
            return -50;
        }
        if (iOException instanceof UnknownHostException) {
            return -51;
        }
        if (iOException instanceof UnknownServiceException) {
            return -52;
        }
        if (iOException instanceof UnsupportedEncodingException) {
            return -53;
        }
        if (iOException instanceof ZipException) {
            return -54;
        }
        return -2;
    }

    private static g a(String string, String string2, Bundle bundle) throws IOException {
        g g2;
        Bundle bundle2 = null;
        bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        if (string2.equalsIgnoreCase("GET")) {
            Map<String, String> map = HttpUtils.a(bundle2);
            Bundle bundle3 = d.b(bundle2);
            if (bundle3 != bundle2) {
                SLog.i("openSDK_LOG.HttpUtils", "-->openUrl encodedParam =" + bundle3.toString() + " -- url = " + string);
            } else {
                SLog.i("openSDK_LOG.HttpUtils", "-->openUrl encodedParam =" + map.toString() + " -- url = " + string);
            }
            g2 = f.a().a(string, map);
        } else if (string2.equalsIgnoreCase("POST")) {
            Map<String, String> map = HttpUtils.a(bundle2);
            Map<String, byte[]> map2 = HttpUtils.b(bundle2);
            if (map2 == null || map2.size() == 0) {
                g2 = f.a().b(string, map);
            } else {
                SLog.w("openSDK_LOG.HttpUtils", "openUrl: has binary " + map2.size());
                g2 = f.a().a(string, map, map2);
            }
        } else {
            SLog.e("openSDK_LOG.HttpUtils", "openUrl: http method " + string2 + " is not supported.");
            throw new IOException("http method is not supported.");
        }
        return g2;
    }

    public static String encodeUrl(Bundle bundle) {
        Map<String, String> map = HttpUtils.a(bundle);
        return HttpUtils.encodeUrl(map);
    }

    public static String encodeUrl(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(URLEncoder.encode(string)).append("=").append(URLEncoder.encode(map.get(string)));
        }
        return stringBuilder.toString();
    }

    private static Map<String, String> a(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (bundle == null || bundle.size() == 0) {
            return hashMap;
        }
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (!(object instanceof String) && !(object instanceof String[])) {
                SLog.w("openSDK_LOG.HttpUtils", "parseBundleToMap: the type " + object.getClass() + " is unsupported");
                continue;
            }
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (i2 != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(stringArray[i2]);
                }
                hashMap.put(string, stringBuilder.toString());
                continue;
            }
            hashMap.put(string, (String)object);
        }
        return hashMap;
    }

    private static Map<String, byte[]> b(Bundle bundle) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(0);
        if (bundle == null || bundle.size() == 0) {
            return hashMap;
        }
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (!(object instanceof byte[])) continue;
            hashMap.put(string, (byte[])object);
        }
        return hashMap;
    }

    public static a getProxy(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (networkInfo == null) {
            return null;
        }
        int n2 = networkInfo.getType();
        if (n2 == 0) {
            String string = HttpUtils.b(context);
            int n3 = HttpUtils.a(context);
            if (!TextUtils.isEmpty((CharSequence)string) && n3 >= 0) {
                return new a(string, n3);
            }
        }
        return null;
    }

    private static int a(Context context) {
        int n2 = -1;
        if (Build.VERSION.SDK_INT < 11) {
            if (context != null) {
                n2 = Proxy.getPort((Context)context);
                if (n2 < 0) {
                    n2 = Proxy.getDefaultPort();
                }
            } else {
                n2 = Proxy.getDefaultPort();
            }
        } else {
            String string = System.getProperty("http.proxyPort");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return n2;
    }

    private static String b(Context context) {
        String string = null;
        if (Build.VERSION.SDK_INT < 11) {
            if (context != null) {
                string = Proxy.getHost((Context)context);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = Proxy.getDefaultHost();
                }
            } else {
                string = Proxy.getDefaultHost();
            }
        } else {
            string = System.getProperty("http.proxyHost");
        }
        return string;
    }

    public static class a {
        public final String a;
        public final int b;

        private a(String string, int n2) {
            this.a = string;
            this.b = n2;
        }
    }

    public static class NetworkUnavailableException
    extends Exception {
        public static final String ERROR_INFO = "network unavailable";

        public NetworkUnavailableException(String string) {
            super(string);
        }
    }

    public static class HttpStatusException
    extends Exception {
        public static final String ERROR_INFO = "http status code error:";
        public final int statusCode;

        public HttpStatusException(String string) {
            super(string);
            this.statusCode = -1;
        }

        public HttpStatusException(int n2) {
            super(ERROR_INFO + n2);
            this.statusCode = n2;
        }
    }
}

