/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.KeyEvent;

class KeyEventCompat {
    private static final KeyEventVersionImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new HoneycombKeyEventVersionImpl() : new BaseKeyEventVersionImpl();

    KeyEventCompat() {
    }

    public static boolean hasModifiers(KeyEvent keyEvent, int n) {
        return IMPL.metaStateHasModifiers(keyEvent.getMetaState(), n);
    }

    public static boolean hasNoModifiers(KeyEvent keyEvent) {
        return IMPL.metaStateHasNoModifiers(keyEvent.getMetaState());
    }

    @TargetApi(value=11)
    private static class HoneycombKeyEventVersionImpl
    extends BaseKeyEventVersionImpl {
        private HoneycombKeyEventVersionImpl() {
        }

        @Override
        public boolean metaStateHasModifiers(int n, int n2) {
            return KeyEvent.metaStateHasModifiers((int)n, (int)n2);
        }

        @Override
        public boolean metaStateHasNoModifiers(int n) {
            return KeyEvent.metaStateHasNoModifiers((int)n);
        }
    }

    private static class BaseKeyEventVersionImpl
    implements KeyEventVersionImpl {
        private static final int META_MODIFIER_MASK = 247;
        private static final int META_ALL_MASK = 247;

        private BaseKeyEventVersionImpl() {
        }

        private static int metaStateFilterDirectionalModifiers(int n, int n2, int n3, int n4, int n5) {
            boolean bl;
            boolean bl2 = (n2 & n3) != 0;
            int n6 = n4 | n5;
            boolean bl3 = bl = (n2 & n6) != 0;
            if (bl2) {
                if (bl) {
                    throw new IllegalArgumentException("bad arguments");
                }
                return n & ~n6;
            }
            if (bl) {
                return n & ~n3;
            }
            return n;
        }

        private int normalizeMetaState(int n) {
            if ((n & 0xC0) != 0) {
                n |= 1;
            }
            if ((n & 0x30) != 0) {
                n |= 2;
            }
            return n & 0xF7;
        }

        @Override
        public boolean metaStateHasModifiers(int n, int n2) {
            n = this.normalizeMetaState(n) & 0xF7;
            n = BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(n, n2, 1, 64, 128);
            return (n = BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(n, n2, 2, 16, 32)) == n2;
        }

        @Override
        public boolean metaStateHasNoModifiers(int n) {
            return (this.normalizeMetaState(n) & 0xF7) == 0;
        }
    }

    static interface KeyEventVersionImpl {
        public boolean metaStateHasModifiers(int var1, int var2);

        public boolean metaStateHasNoModifiers(int var1);
    }
}

