/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.common;

import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.umeng.socialize.utils.SocializeUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class QueuedWork {
    public static boolean isUseThreadPool = false;
    private static Handler uiHandler;
    private static ExecutorService mLogicExecutor;
    private static ExecutorService mNetExecutor;

    public static void runInMain(Runnable runnable) {
        if (uiHandler == null) {
            uiHandler = new Handler(Looper.getMainLooper());
        }
        uiHandler.post(runnable);
    }

    public static void runInBack(Runnable runnable, boolean bl) {
        if (isUseThreadPool) {
            if (bl) {
                mNetExecutor.execute(runnable);
            } else {
                mLogicExecutor.execute(runnable);
            }
        } else {
            new Thread(runnable).start();
        }
    }

    static {
        mLogicExecutor = Executors.newFixedThreadPool(5);
        mNetExecutor = Executors.newFixedThreadPool(5);
    }

    public static abstract class UMAsyncTask<Result> {
        protected Runnable thread;

        protected void onPreExecute() {
        }

        protected abstract Result doInBackground();

        protected void onPostExecute(Result Result) {
        }

        public final UMAsyncTask<Result> execute() {
            this.thread = new Runnable(){

                @Override
                public void run() {
                    final Object Result = UMAsyncTask.this.doInBackground();
                    QueuedWork.runInMain(new Runnable(){

                        @Override
                        public void run() {
                            UMAsyncTask.this.onPostExecute(Result);
                        }
                    });
                }
            };
            QueuedWork.runInMain(new Runnable(){

                @Override
                public void run() {
                    UMAsyncTask.this.onPreExecute();
                }
            });
            QueuedWork.runInBack(this.thread, false);
            return this;
        }
    }

    public static abstract class DialogThread<T>
    extends UMAsyncTask {
        Dialog dialog = null;

        public DialogThread(Context context) {
        }

        protected void onPostExecute(Object object) {
            super.onPostExecute(object);
            SocializeUtils.safeCloseDialog(this.dialog);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            SocializeUtils.safeShowDialog(this.dialog);
        }
    }
}

