/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.tencent.mm.opensdk.modelmsg.WXEmojiObject;
import com.tencent.mm.opensdk.modelmsg.WXFileObject;
import com.tencent.mm.opensdk.modelmsg.WXImageObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMiniProgramObject;
import com.tencent.mm.opensdk.modelmsg.WXMusicObject;
import com.tencent.mm.opensdk.modelmsg.WXTextObject;
import com.tencent.mm.opensdk.modelmsg.WXVideoObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.umeng.socialize.Config;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMEmoji;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMMin;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMWeb;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.File;

public class WeiXinShareContent
extends SimpleShareContent {
    private final boolean bySystem;

    public WeiXinShareContent(ShareContent shareContent) {
        super(shareContent);
        this.bySystem = shareContent.bySystem;
    }

    public boolean isBySystem() {
        return this.bySystem;
    }

    public WXMediaMessage getWxMediaMessage(Context context, boolean useFileProvider, String fileProvider) {
        WXMediaMessage wxMessage = this.getmStyle() == 2 || this.getmStyle() == 3 ? (useFileProvider ? this.buildImageParamsWithFileProvider(context, fileProvider) : this.buildImageParams()) : (this.getmStyle() == 4 ? this.buildMusicParams() : (this.getmStyle() == 16 ? this.buildUrlParams() : (this.getmStyle() == 8 ? this.buildVideoParams() : (this.getmStyle() == 64 ? (useFileProvider ? this.buildEmojiParamsWithFileProvider(context, fileProvider) : this.buildEmojiParams()) : (this.getmStyle() == 32 ? this.buildFileParams() : (this.getmStyle() == 128 ? this.buildMinApp() : this.buildTextParams()))))));
        return wxMessage;
    }

    private WXMediaMessage buildEmojiParamsWithFileProvider(Context context, String fileProvider) {
        UMEmoji emoji = this.getUmEmoji();
        String path = "";
        String contentPath = "";
        if (emoji != null && emoji.asFileImage() != null) {
            path = emoji.asFileImage().toString();
            File file = new File(path);
            contentPath = this.getFileUri(context, file, fileProvider);
        }
        WXEmojiObject wxEmojiObject = new WXEmojiObject();
        wxEmojiObject.emojiPath = contentPath;
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = wxEmojiObject;
        msg.thumbData = this.objectSetThumb((BaseMediaObject)emoji);
        return msg;
    }

    private WXMediaMessage buildEmojiParams() {
        UMEmoji emoji = this.getUmEmoji();
        String path = "";
        if (emoji != null && emoji.asFileImage() != null) {
            path = emoji.asFileImage().toString();
        }
        WXEmojiObject wxEmojiObject = new WXEmojiObject();
        wxEmojiObject.emojiPath = path;
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = wxEmojiObject;
        msg.thumbData = this.objectSetThumb((BaseMediaObject)emoji);
        return msg;
    }

    private WXMediaMessage buildMusicParams() {
        UMusic umusic = this.getMusic();
        WXMusicObject music = new WXMusicObject();
        music.musicUrl = this.getMusicTargetUrl(umusic);
        music.musicDataUrl = umusic.toUrl();
        if (!TextUtils.isEmpty((CharSequence)umusic.getLowBandDataUrl())) {
            music.musicLowBandDataUrl = umusic.getLowBandDataUrl();
        }
        if (!TextUtils.isEmpty((CharSequence)umusic.getLowBandUrl())) {
            music.musicLowBandUrl = umusic.getLowBandUrl();
        }
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = music;
        msg.title = this.objectSetTitle((BaseMediaObject)umusic);
        msg.description = this.objectSetDescription((BaseMediaObject)umusic);
        msg.mediaObject = music;
        msg.thumbData = this.objectSetThumb((BaseMediaObject)umusic);
        return msg;
    }

    private WXMediaMessage buildFileParams() {
        WXFileObject textObj = new WXFileObject();
        textObj.fileData = SocializeUtils.File2byte((File)this.getFile());
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = textObj;
        msg.description = this.getText();
        msg.title = this.getSubject();
        return msg;
    }

    private WXMediaMessage buildMinApp() {
        UMMin umMin = this.getUmMin();
        WXMiniProgramObject wxMiniProgramObject = new WXMiniProgramObject();
        wxMiniProgramObject.webpageUrl = umMin.toUrl();
        wxMiniProgramObject.userName = umMin.getUserName();
        wxMiniProgramObject.path = umMin.getPath();
        wxMiniProgramObject.miniprogramType = Config.getMINITYPE();
        WXMediaMessage msg = new WXMediaMessage();
        msg.title = this.objectSetTitle((BaseMediaObject)umMin);
        msg.description = this.objectSetDescription((BaseMediaObject)umMin);
        msg.thumbData = this.objectSetMInAppThumb((BaseMediaObject)umMin);
        msg.mediaObject = wxMiniProgramObject;
        return msg;
    }

    private WXMediaMessage buildTextParams() {
        WXTextObject textObj = new WXTextObject();
        textObj.text = this.objectSetText(this.getText());
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = textObj;
        msg.description = this.objectSetText(this.getText(), 1024);
        return msg;
    }

    private WXMediaMessage buildImageParams() {
        UMImage img = this.getImage();
        WXImageObject imgObj = new WXImageObject();
        WXMediaMessage msg = new WXMediaMessage();
        imgObj.imageData = img.asBinImage();
        if (this.canFileValid(img)) {
            imgObj.imagePath = img.asFileImage().toString();
            imgObj.imageData = null;
        } else {
            imgObj.imageData = this.getStrictImageData(img);
        }
        msg.thumbData = this.getImageThumb(img);
        msg.mediaObject = imgObj;
        return msg;
    }

    private WXMediaMessage buildImageParamsWithFileProvider(Context context, String fileProvider) {
        UMImage img = this.getImage();
        WXImageObject imgObj = new WXImageObject();
        WXMediaMessage msg = new WXMediaMessage();
        imgObj.imageData = img.asBinImage();
        if (this.canFileValid(img)) {
            String contentPath;
            String filePath = img.asFileImage().toString();
            File file = new File(filePath);
            imgObj.imagePath = contentPath = this.getFileUri(context, file, fileProvider);
            imgObj.imageData = null;
        } else {
            imgObj.imageData = this.getStrictImageData(img);
        }
        msg.thumbData = this.getImageThumb(img);
        msg.mediaObject = imgObj;
        return msg;
    }

    public String getFileUri(Context context, File file, String fileProvider) {
        if (file == null || !file.exists()) {
            return null;
        }
        Uri contentUri = FileProvider.getUriForFile((Context)context, (String)fileProvider, (File)file);
        context.grantUriPermission("com.tencent.mm", contentUri, 1);
        return contentUri.toString();
    }

    private WXMediaMessage buildVideoParams() {
        UMVideo uvideo = this.getVideo();
        WXVideoObject video = new WXVideoObject();
        video.videoUrl = uvideo.toUrl();
        if (!TextUtils.isEmpty((CharSequence)uvideo.getLowBandUrl())) {
            video.videoLowBandUrl = uvideo.getLowBandUrl();
        }
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = video;
        msg.title = this.objectSetTitle((BaseMediaObject)uvideo);
        msg.description = this.objectSetDescription((BaseMediaObject)uvideo);
        msg.thumbData = this.objectSetThumb((BaseMediaObject)uvideo);
        return msg;
    }

    private WXMediaMessage buildUrlParams() {
        UMWeb umWeb = this.getUmWeb();
        WXWebpageObject webpage = new WXWebpageObject();
        webpage.webpageUrl = umWeb.toUrl();
        WXMediaMessage msg = new WXMediaMessage();
        msg.title = this.objectSetTitle((BaseMediaObject)umWeb);
        msg.description = this.objectSetDescription((BaseMediaObject)umWeb);
        msg.mediaObject = webpage;
        msg.thumbData = this.objectSetThumb((BaseMediaObject)umWeb);
        return msg;
    }
}

