/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.os.Build;
import android.view.VelocityTracker;

class VelocityTrackerCompat {
    private static final VelocityTrackerVersionImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new HoneycombVelocityTrackerVersionImpl() : new BaseVelocityTrackerVersionImpl();

    VelocityTrackerCompat() {
    }

    static float getXVelocity(VelocityTracker velocityTracker, int n) {
        return IMPL.getXVelocity(velocityTracker, n);
    }

    private static class HoneycombVelocityTrackerVersionImpl
    implements VelocityTrackerVersionImpl {
        private HoneycombVelocityTrackerVersionImpl() {
        }

        @Override
        public float getXVelocity(VelocityTracker velocityTracker, int n) {
            return velocityTracker.getXVelocity(n);
        }
    }

    private static class BaseVelocityTrackerVersionImpl
    implements VelocityTrackerVersionImpl {
        private BaseVelocityTrackerVersionImpl() {
        }

        @Override
        public float getXVelocity(VelocityTracker velocityTracker, int n) {
            return velocityTracker.getXVelocity();
        }
    }

    static interface VelocityTrackerVersionImpl {
        public float getXVelocity(VelocityTracker var1, int var2);
    }
}

