/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.social.tool;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;

public class ComposeTool {
    public static ComposeDirection direction = ComposeDirection.CUSTOM;
    public static int textColor = -16777216;
    public static int textsize = 18;
    public static int backgroundColor = -1;
    public static Typeface typeface = Typeface.DEFAULT;

    public static Bitmap createCompose(Bitmap bitmap, Bitmap bitmap2, boolean bl, int n) {
        if (bitmap == null) {
            return null;
        }
        if (bitmap2 == null) {
            return null;
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        int n6 = bl ? Math.max(n2, n4) : n2 + n4 + n;
        int n7 = bl ? n3 + n5 + n : Math.max(n3, n5);
        Bitmap bitmap3 = Bitmap.createBitmap((int)n6, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap3);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        if (bl) {
            canvas.drawBitmap(bitmap2, 0.0f, (float)(n3 + n), null);
        } else {
            canvas.drawBitmap(bitmap2, (float)(n2 + n), 0.0f, null);
        }
        return bitmap3;
    }

    public static Bitmap createWaterMask(Bitmap bitmap, Bitmap bitmap2, int n, int n2) {
        if (bitmap == null) {
            return null;
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int n5 = bitmap2.getWidth();
        int n6 = bitmap2.getHeight();
        int n7 = n3 / 2 - n5 / 2;
        int n8 = n4 / 2 - n6 / 2;
        Bitmap bitmap3 = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap3);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        if (direction == ComposeDirection.CUSTOM) {
            canvas.drawBitmap(bitmap2, (float)n, (float)n2, null);
        } else if (direction == ComposeDirection.UP) {
            canvas.drawBitmap(bitmap2, (float)n7, 0.0f, null);
        } else if (direction == ComposeDirection.DOWN) {
            canvas.drawBitmap(bitmap2, (float)n7, (float)(n4 - n6), null);
        } else if (direction == ComposeDirection.LEFT) {
            canvas.drawBitmap(bitmap2, 0.0f, (float)n8, null);
        } else if (direction == ComposeDirection.RIGHT) {
            canvas.drawBitmap(bitmap2, (float)(n3 - n5), (float)n8, null);
        } else if (direction == ComposeDirection.LEFTUP) {
            canvas.drawBitmap(bitmap2, 0.0f, 0.0f, null);
        } else if (direction == ComposeDirection.LEFTDOWN) {
            canvas.drawBitmap(bitmap2, 0.0f, (float)(n4 - n6), null);
        } else if (direction == ComposeDirection.RIGHTUP) {
            canvas.drawBitmap(bitmap2, (float)(n3 - n5), 0.0f, null);
        } else if (direction == ComposeDirection.RIGHTDOWN) {
            canvas.drawBitmap(bitmap2, (float)(n3 - n5), (float)(n4 - n6), null);
        }
        return bitmap3;
    }

    public static Bitmap createTextImage(String string, Bitmap bitmap, int n, int n2) {
        Bitmap.Config config = bitmap.getConfig();
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        TextPaint textPaint = new TextPaint(1);
        textPaint.setColor(textColor);
        textPaint.setTextSize((float)textsize);
        textPaint.setDither(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTypeface(typeface);
        StaticLayout staticLayout = new StaticLayout((CharSequence)string, textPaint, n3, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        Rect rect = new Rect();
        textPaint.getTextBounds(string, 0, string.length(), rect);
        bitmap = bitmap.copy(config, true);
        Bitmap bitmap2 = Bitmap.createBitmap((int)(n3 + n * 2), (int)(n4 + staticLayout.getHeight() + n2 * 4), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawColor(backgroundColor);
        canvas.drawBitmap(bitmap, (float)n, (float)(staticLayout.getHeight() + n2 * 3), null);
        canvas.translate((float)n, (float)n2);
        staticLayout.draw(canvas);
        return bitmap2;
    }

    public static enum ComposeDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        LEFTUP,
        LEFTDOWN,
        RIGHTUP,
        RIGHTDOWN,
        CUSTOM;

    }
}

