/*
 * Decompiled with CFR 0.152.
 */
package com.anji.appsp.sdk.notice;

import android.text.TextUtils;
import com.anji.appsp.sdk.AppSpLog;
import com.anji.appsp.sdk.base.AppSpBaseHandler;
import com.anji.appsp.sdk.model.AppSpModel;
import com.anji.appsp.sdk.model.AppSpNoticeModelItem;
import com.anji.appsp.sdk.notice.service.IAppSpNoticeCallback;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppSpNoticeHandler
extends AppSpBaseHandler {
    private IAppSpNoticeCallback appSpNoticeCallback;

    public void setAppSpNoticeCallback(IAppSpNoticeCallback appSpNoticeCallback) {
        this.appSpNoticeCallback = appSpNoticeCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNoticeSuccess(String data) {
        if (this.appSpNoticeCallback != null) {
            IAppSpNoticeCallback iAppSpNoticeCallback = this.appSpNoticeCallback;
            synchronized (iAppSpNoticeCallback) {
                try {
                    AppSpModel<List<AppSpNoticeModelItem>> spVersionModel = new AppSpModel<List<AppSpNoticeModelItem>>();
                    JSONObject jsonObject = new JSONObject(data);
                    spVersionModel.setRepCode(this.getStringElement(jsonObject.opt("repCode")));
                    spVersionModel.setRepMsg(this.getStringElement(jsonObject.opt("repMsg")));
                    Object repDtaObj = jsonObject.opt("repData");
                    if (repDtaObj != null && !TextUtils.isEmpty((CharSequence)repDtaObj.toString()) && !"null".equalsIgnoreCase(repDtaObj.toString())) {
                        JSONArray repData = new JSONArray(repDtaObj.toString());
                        ArrayList<AppSpNoticeModelItem> items = new ArrayList<AppSpNoticeModelItem>();
                        if (repData != null) {
                            for (int i = 0; i < repData.length(); ++i) {
                                AppSpNoticeModelItem item = new AppSpNoticeModelItem();
                                JSONObject value = repData.getJSONObject(i);
                                item.setTitle(this.getStringElement(value.opt("title")));
                                item.setDetails(this.getStringElement(value.opt("details")));
                                item.setTemplateType(this.getStringElement(value.opt("templateType")));
                                item.setTemplateTypeName(this.getStringElement(value.opt("templateTypeName")));
                                items.add(item);
                            }
                            spVersionModel.setRepData(items);
                            this.appSpNoticeCallback.notice(spVersionModel);
                        }
                    }
                    AppSpLog.d("\u901a\u77e5\u8fd4\u56de\u5ba2\u6237\u7aef\u6570\u636e " + spVersionModel);
                }
                catch (Exception e) {
                    AppSpLog.d("\u901a\u77e5\u8fd4\u56de\u5ba2\u6237\u7aef\u6570\u636e Exception e " + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNoticeExcption(String code, String msg) {
        if (this.appSpNoticeCallback != null) {
            IAppSpNoticeCallback iAppSpNoticeCallback = this.appSpNoticeCallback;
            synchronized (iAppSpNoticeCallback) {
                this.appSpNoticeCallback.error(code, msg);
            }
        }
    }
}

