/*
 * Decompiled with CFR 0.152.
 */
package com.anji.appsp.sdk.http;

import com.anji.appsp.sdk.AppSpLog;
import com.anji.appsp.sdk.http.AppSpCallBack;
import com.anji.appsp.sdk.http.AppSpRequestMethod;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AppSpHttpClient {
    private static final String TAG = AppSpHttpClient.class.getSimpleName();

    public void request(String url, AppSpCallBack appSpCallBack) {
        this.request(url, null, AppSpRequestMethod.POST, appSpCallBack);
    }

    public void request(String url, Object data, AppSpCallBack appSpCallBack) {
        this.request(url, data, AppSpRequestMethod.POST, appSpCallBack);
    }

    public void request(String url, Object data, AppSpRequestMethod appSpRequestMethod, AppSpCallBack appSpCallBack) {
        if (appSpCallBack == null) {
            return;
        }
        new RequestWrapper(url, data, appSpRequestMethod, appSpCallBack).requestWrapper();
    }

    class RequestWrapper {
        private String baseUrl;
        private Object params;
        private AppSpRequestMethod appSpRequestMethod;
        private AppSpCallBack appSpCallBack;
        Thread thread = new Thread(){

            @Override
            public void run() {
                RequestWrapper.this.requestSync();
            }
        };
        final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };

        public RequestWrapper(String baseUrl, Object params, AppSpRequestMethod appSpRequestMethod, AppSpCallBack appSpCallBack) {
            this.baseUrl = baseUrl;
            this.params = params;
            this.appSpRequestMethod = appSpRequestMethod;
            this.appSpCallBack = appSpCallBack;
        }

        private void requestSync() {
            AppSpLog.d("\u8bf7\u6c42\u5730\u5740 " + this.baseUrl);
            try {
                HttpURLConnection urlConn = this.getConnection();
                if (urlConn == null) {
                    return;
                }
                String paramsStr = this.params.toString();
                AppSpLog.d("\u8bf7\u6c42\u5185\u5bb9 " + paramsStr);
                byte[] postData = paramsStr.getBytes();
                DataOutputStream dos = new DataOutputStream(urlConn.getOutputStream());
                dos.write(postData);
                dos.flush();
                dos.close();
                if (urlConn.getResponseCode() == 200) {
                    String result;
                    String respData = result = this.streamToString(urlConn.getInputStream());
                    AppSpLog.d("\u8bf7\u6c42\u6210\u529f\uff0c\u7ed3\u679c\u4e3a\uff1a " + result);
                    this.requestSuccess(respData);
                } else {
                    this.fail(String.valueOf(urlConn.getResponseCode()), urlConn.getResponseMessage());
                    AppSpLog.d("\u8bf7\u6c42\u5931\u8d25 ");
                }
                urlConn.disconnect();
            }
            catch (Exception e) {
                AppSpLog.e("\u8bf7\u6c42\u5f02\u5e38 " + e.toString());
                this.fail("1001", e.toString());
            }
        }

        public void requestWrapper() {
            this.thread.start();
        }

        private HttpURLConnection getConnection() {
            HttpURLConnection urlConn = null;
            try {
                URL url = new URL(this.baseUrl);
                this.trustAllHosts();
                if (url.getProtocol().toLowerCase().equals("https")) {
                    HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                    https.setHostnameVerifier(this.DO_NOT_VERIFY);
                    urlConn = https;
                } else {
                    urlConn = (HttpURLConnection)url.openConnection();
                }
                urlConn.setConnectTimeout(10000);
                urlConn.setReadTimeout(10000);
                urlConn.setDoOutput(true);
                urlConn.setDoInput(true);
                urlConn.setUseCaches(false);
                String method = "POST";
                if (AppSpRequestMethod.POST == this.appSpRequestMethod) {
                    method = "POST";
                } else if (AppSpRequestMethod.GET == this.appSpRequestMethod) {
                    method = "GET";
                } else if (AppSpRequestMethod.PUT == this.appSpRequestMethod) {
                    method = "PUT";
                } else if (AppSpRequestMethod.DELETE == this.appSpRequestMethod) {
                    method = "DELETE";
                }
                urlConn.setRequestMethod(method);
                urlConn.setRequestProperty("Content-Type", "application/json");
                urlConn.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return urlConn;
        }

        private void fail(String code, String msg) {
            this.appSpCallBack.onError(code, msg);
        }

        private void requestSuccess(String data) {
            this.appSpCallBack.onSuccess(data);
        }

        private void trustAllHosts() {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    AppSpLog.d("checkClientTrusted");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    AppSpLog.d("checkServerTrusted");
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String streamToString(InputStream is) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                baos.close();
                is.close();
                byte[] byteArray = baos.toByteArray();
                return new String(byteArray);
            }
            catch (Exception e) {
                AppSpLog.e("\u4ece\u7f51\u7edc\u83b7\u53d6\u7684\u8f93\u5165\u6d41 \u8bf7\u6c42\u5f02\u5e38 " + e.toString());
                return null;
            }
        }
    }
}

