/*
 * Decompiled with CFR 0.152.
 */
package com.anji.appsp.sdk.notice.impl;

import android.content.Context;
import android.text.TextUtils;
import com.anji.appsp.sdk.AppSpLog;
import com.anji.appsp.sdk.base.AppSpBaseRequest;
import com.anji.appsp.sdk.http.AppSpCallBack;
import com.anji.appsp.sdk.http.AppSpHttpClient;
import com.anji.appsp.sdk.http.AppSpPostData;
import com.anji.appsp.sdk.http.AppSpRequestUrl;
import com.anji.appsp.sdk.notice.AppSpNoticeHandler;
import com.anji.appsp.sdk.notice.service.IAppSpNoticeService;

public class AppSpNoticeServiceImpl
extends AppSpBaseRequest
implements IAppSpNoticeService {
    private AppSpNoticeHandler appSpNoticeHandler;

    public AppSpNoticeServiceImpl(Context mContext, String appKey, AppSpNoticeHandler appSpNoticeHandler) {
        super(mContext, appKey);
        this.appSpNoticeHandler = appSpNoticeHandler;
    }

    @Override
    public void getNotice() {
        if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            AppSpLog.e("getNotice Appkey is null or empty");
            return;
        }
        AppSpPostData appSpPostData = this.getPostEncryptData();
        AppSpHttpClient client = new AppSpHttpClient();
        client.request(AppSpRequestUrl.Host + "/sp/phone/appNotice", appSpPostData, new AppSpCallBack(){

            @Override
            public void onSuccess(String data) {
                if (AppSpNoticeServiceImpl.this.appSpNoticeHandler != null) {
                    AppSpNoticeServiceImpl.this.appSpNoticeHandler.handleNoticeSuccess(data);
                }
            }

            @Override
            public void onError(String code, String msg) {
                if (AppSpNoticeServiceImpl.this.appSpNoticeHandler != null) {
                    AppSpNoticeServiceImpl.this.appSpNoticeHandler.handleNoticeExcption(code, msg);
                }
            }
        });
    }
}

