/*
 * Decompiled with CFR 0.152.
 */
package com.anji.appsp.sdk.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.anji.appsp.sdk.AppSpLog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Locale;

public class PhoneUtil {
    public static String getDeviceId(Context context) {
        return PhoneUtil.getDeviceId(context, 128);
    }

    public static String getDeviceId(Context context, int length) {
        String androidId = PhoneUtil.getAndroidId(context);
        String mac = PhoneUtil.getMac(context);
        AppSpLog.d(" getDeviceId androidId " + androidId + " mac " + mac);
        String deviceId = androidId + mac;
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = PhoneUtil.getPhoneUUID();
        } else if (deviceId.length() >= length) {
            deviceId = deviceId.substring(0, length);
        }
        return deviceId;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String[] getNetworkAccessMode(Context paramContext) {
        String[] arrayOfString = new String[]{"", ""};
        if (paramContext == null) {
            return arrayOfString;
        }
        try {
            if (!PhoneUtil.checkPermission(paramContext, "android.permission.ACCESS_NETWORK_STATE")) {
                arrayOfString[0] = "";
                return arrayOfString;
            }
            ConnectivityManager localConnectivityManager = (ConnectivityManager)paramContext.getSystemService("connectivity");
            if (localConnectivityManager == null) {
                arrayOfString[0] = "";
                return arrayOfString;
            }
            NetworkInfo localNetworkInfo1 = localConnectivityManager.getNetworkInfo(1);
            if (localNetworkInfo1 != null && localNetworkInfo1.getState() == NetworkInfo.State.CONNECTED) {
                arrayOfString[0] = "Wi-Fi";
                return arrayOfString;
            }
            NetworkInfo localNetworkInfo2 = localConnectivityManager.getNetworkInfo(0);
            if (localNetworkInfo2 != null && localNetworkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                arrayOfString[0] = "2G/3G";
                arrayOfString[1] = localNetworkInfo2.getSubtypeName();
                return arrayOfString;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return arrayOfString;
    }

    public static String getMac(Context paramContext) {
        String str = "";
        if (paramContext == null) {
            return str;
        }
        if (Build.VERSION.SDK_INT < 23) {
            str = PhoneUtil.getMacBySystemInterface(paramContext);
        } else if (Build.VERSION.SDK_INT == 23) {
            str = PhoneUtil.getMacByJavaAPI();
            if (TextUtils.isEmpty((CharSequence)str)) {
                str = PhoneUtil.getMacShell();
            }
        } else {
            str = PhoneUtil.getMacByJavaAPI();
            if (TextUtils.isEmpty((CharSequence)str)) {
                str = PhoneUtil.getMacBySystemInterface(paramContext);
            }
        }
        return str;
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getMacBySystemInterface(Context paramContext) {
        if (paramContext == null) {
            return "";
        }
        try {
            WifiManager localWifiManager = (WifiManager)paramContext.getSystemService("wifi");
            if (PhoneUtil.checkPermission(paramContext, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo localWifiInfo = localWifiManager.getConnectionInfo();
                return localWifiInfo.getMacAddress();
            }
            return "";
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static String getMacByJavaAPI() {
        try {
            Enumeration<NetworkInterface> localEnumeration = NetworkInterface.getNetworkInterfaces();
            while (localEnumeration.hasMoreElements()) {
                NetworkInterface localNetworkInterface = localEnumeration.nextElement();
                if (!"wlan0".equals(localNetworkInterface.getName()) && !"eth0".equals(localNetworkInterface.getName())) continue;
                byte[] arrayOfByte1 = localNetworkInterface.getHardwareAddress();
                if (arrayOfByte1 == null || arrayOfByte1.length == 0) {
                    return "";
                }
                StringBuilder localStringBuilder = new StringBuilder();
                for (byte b : arrayOfByte1) {
                    localStringBuilder.append(String.format("%02X:", b));
                }
                if (localStringBuilder.length() > 0) {
                    localStringBuilder.deleteCharAt(localStringBuilder.length() - 1);
                }
                return localStringBuilder.toString().toLowerCase(Locale.getDefault());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String getMacShell() {
        try {
            String[] arrayOfString = new String[]{"/sys/class/net/wlan0/address", "/sys/class/net/eth0/address", "/sys/devices/virtual/net/wlan0/address"};
            for (int i = 0; i < arrayOfString.length; ++i) {
                try {
                    String str = PhoneUtil.reaMac(arrayOfString[i]);
                    if (str == null) continue;
                    return str;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reaMac(String paramString) {
        String str = null;
        try {
            FileReader localFileReader = new FileReader(paramString);
            BufferedReader localBufferedReader = null;
            if (localFileReader != null) {
                try {
                    localBufferedReader = new BufferedReader(localFileReader, 1024);
                    str = localBufferedReader.readLine();
                }
                finally {
                    if (localFileReader != null) {
                        try {
                            localFileReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (localBufferedReader != null) {
                        try {
                            localBufferedReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            return str;
        }
        catch (Throwable throwable) {
            return str;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getImei(Context paramContext) {
        String str;
        block6: {
            str = "";
            try {
                TelephonyManager localTelephonyManager;
                if (paramContext == null || (localTelephonyManager = (TelephonyManager)paramContext.getSystemService("phone")) == null || !PhoneUtil.checkPermission(paramContext, "android.permission.READ_PHONE_STATE")) break block6;
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        Method localMethod = localTelephonyManager.getClass().getMethod("getImei", new Class[0]);
                        localMethod.setAccessible(true);
                        str = (String)localMethod.invoke((Object)localTelephonyManager, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (TextUtils.isEmpty((CharSequence)str)) {
                        str = localTelephonyManager.getDeviceId();
                    }
                    break block6;
                }
                str = localTelephonyManager.getDeviceId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getImsi(Context paramContext) {
        if (paramContext == null) {
            return null;
        }
        TelephonyManager localTelephonyManager = (TelephonyManager)paramContext.getSystemService("phone");
        String str = null;
        if (PhoneUtil.checkPermission(paramContext, "android.permission.READ_PHONE_STATE")) {
            str = localTelephonyManager.getSubscriberId();
        }
        return str;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getMeid(Context paramContext) {
        if (paramContext == null) {
            return "";
        }
        String str = "";
        TelephonyManager localTelephonyManager = (TelephonyManager)paramContext.getSystemService("phone");
        if (PhoneUtil.checkPermission(paramContext, "android.permission.READ_PHONE_STATE") && localTelephonyManager != null) {
            if (Build.VERSION.SDK_INT < 26) {
                str = localTelephonyManager.getDeviceId();
            } else {
                try {
                    str = PhoneUtil.getMeidReal(paramContext);
                    if (TextUtils.isEmpty((CharSequence)str)) {
                        str = localTelephonyManager.getDeviceId();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return str;
    }

    private static String getMeidReal(Context paramContext) {
        if (paramContext == null) {
            return "";
        }
        String str = "";
        try {
            Class<?> localClass = Class.forName("android.telephony.TelephonyManager");
            Method localMethod = localClass.getMethod("getMeid", new Class[0]);
            Object localObject = localMethod.invoke(null, new Object[0]);
            if (null != localObject && localObject instanceof String) {
                str = (String)localObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private static String getNotNullStr(Object input) {
        return input == null ? "" : input.toString();
    }

    public static String getAndroidId(Context context) {
        String androidId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return PhoneUtil.getNotNullStr(androidId);
    }

    private static String getPhoneUUID() {
        StringBuffer sb = new StringBuffer();
        sb.append("35");
        sb.append(PhoneUtil.getNotNullStr(Build.BOARD.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.BRAND.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.CPU_ABI.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.DEVICE.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.DISPLAY.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.HOST.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.ID.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.MANUFACTURER.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.MODEL.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.PRODUCT.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.TAGS.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.TYPE.length() % 10));
        sb.append(PhoneUtil.getNotNullStr(Build.USER.length() % 10));
        String imei = sb.toString();
        return imei;
    }

    public static String getScreenInfo(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.heightPixels + "*" + displayMetrics.widthPixels;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getNetworkState(Context context) {
        String strNetworkType = "unknown";
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (!PhoneUtil.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return strNetworkType;
        }
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = "WIFI";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = "2G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = "3G";
                        break;
                    }
                    case 13: {
                        strNetworkType = "4G";
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3G" : _strSubTypeName;
                    }
                }
            }
        }
        return strNetworkType;
    }

    public static long getVersionCode(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            if (Build.VERSION.SDK_INT >= 28) {
                return info.getLongVersionCode();
            }
            return info.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1L;
        }
    }

    public static String getVersionName(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        boolean checked;
        block7: {
            checked = false;
            if (context == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> localClass = Class.forName("android.content.Context");
                    Method method = localClass.getMethod("checkSelfPermission", String.class);
                    int result = (Integer)method.invoke((Object)context, permission2);
                    if (result == 0) {
                        checked = true;
                        break block7;
                    }
                    checked = false;
                }
                catch (Exception localException) {
                    checked = false;
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager.checkPermission(permission2, context.getPackageName()) == 0) {
                    checked = true;
                }
            }
        }
        return checked;
    }
}

