/*
 * Decompiled with CFR 0.152.
 */
package com.anji.appsp.sdk;

import android.content.Context;
import com.anji.appsp.sdk.AppSpLog;
import com.anji.appsp.sdk.http.AppSpRequestUrl;
import com.anji.appsp.sdk.notice.controller.AppSpNoticeController;
import com.anji.appsp.sdk.notice.service.IAppSpNoticeCallback;
import com.anji.appsp.sdk.version.controller.AppSpVersionController;
import com.anji.appsp.sdk.version.service.IAppSpVersionCallback;

public final class AppSpConfig {
    private static volatile AppSpConfig appSpConfig;
    private Context context;
    private String appKey;

    private AppSpConfig() {
    }

    public static synchronized AppSpConfig getInstance() {
        if (appSpConfig == null) {
            appSpConfig = new AppSpConfig();
        }
        return appSpConfig;
    }

    public AppSpConfig setHost(String host) {
        AppSpRequestUrl.Host = host;
        return appSpConfig;
    }

    public AppSpConfig setDebuggable(boolean debug) {
        AppSpLog.setDebugged(debug);
        return appSpConfig;
    }

    public AppSpConfig init(Context context, String appKey) {
        this.context = context;
        this.appKey = appKey;
        return appSpConfig;
    }

    public void deviceInit() {
        AppSpVersionController appSpVersionController = new AppSpVersionController(this.context, this.appKey);
        appSpVersionController.initDevice();
    }

    public void getVersion(IAppSpVersionCallback iAppSpVersionCallback) {
        AppSpVersionController appSpVersionController = new AppSpVersionController(this.context, this.appKey);
        appSpVersionController.getVersion(iAppSpVersionCallback);
    }

    public void getNotice(IAppSpNoticeCallback iAppSpNoticeCallback) {
        AppSpNoticeController appSpNoticeController = new AppSpNoticeController(this.context, this.appKey);
        appSpNoticeController.getNotice(iAppSpNoticeCallback);
    }
}

